/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.launcher;

import gg.hoplite.mcup.util.OperatingSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativesHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativesHelper.class);
    private static final String OS_ID = OperatingSystem.CURRENT.name().toLowerCase(Locale.ROOT) + "-" + System.getProperty("os.arch").toLowerCase(Locale.ROOT);
    private static final Map<String, String> NATIVES_MAP = NativesHelper.getNativesMap();
    private static boolean loaded = false;

    private static Map<String, String> getNativesMap() {
        HashMap<String, String> natives = new HashMap<String, String>();
        natives.put("windows-aarch64", "natives/windows-ARM64.dll");
        natives.put("windows-win32", "natives/windows-Win32.dll");
        natives.put("windows-amd64", "natives/windows-x64.dll");
        natives.put("macos-x86_64", "natives/macos-x86_64_arm64.dylib");
        natives.put("macos-aarch64", "natives/macos-x86_64_arm64.dylib");
        return natives;
    }

    public static String getNormalisedOsId() {
        String osId = OperatingSystem.CURRENT.name().toLowerCase(Locale.ROOT);
        String archId = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (archId.equals("amd64") || archId.equals("x86")) {
            archId = "x86_64";
        } else if (archId.equals("arm64")) {
            archId = "aarch64";
        }
        return osId + "-" + archId;
    }

    public static boolean loadSafelyIfCompatible() {
        if (NativesHelper.isCompatible()) {
            try {
                NativesHelper.loadNatives();
                return true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to load natives", e);
            }
        }
        return false;
    }

    private static boolean isCompatible() {
        return NATIVES_MAP.containsKey(OS_ID);
    }

    private static void loadNatives() throws IOException {
        if (loaded) {
            return;
        }
        String nativeName = NATIVES_MAP.get(OS_ID);
        Path nativePath = Files.createTempFile("fabric-installer-native", null, new FileAttribute[0]);
        try (InputStream is = NativesHelper.class.getClassLoader().getResourceAsStream(nativeName);){
            Objects.requireNonNull(is, "Could not load: " + nativeName);
            Files.copy(is, nativePath, StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(nativePath.toString());
        loaded = true;
    }

    static {
        LOGGER.info("OS_ID: {}", (Object)OS_ID);
    }
}

