/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Verifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(Verifier.class);
    private final Signature sig;
    private final PublicKey publicKey;

    public Verifier(Signature sig, PublicKey publicKey) {
        this.sig = sig;
        this.publicKey = publicKey;
    }

    public boolean verify(String toVerify, byte[] signature) {
        try {
            this.sig.initVerify(this.publicKey);
            this.sig.update(toVerify.getBytes(StandardCharsets.UTF_8));
            return this.sig.verify(signature);
        }
        catch (InvalidKeyException | SignatureException e) {
            LOGGER.error("Verification failed", e);
            return false;
        }
    }

    public static Verifier create(String publicKeyStr) {
        if (publicKeyStr == null) {
            return null;
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("Ed25519");
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            Signature sig = Signature.getInstance("Ed25519");
            return new Verifier(sig, publicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("Creating verifier failed", e);
            return null;
        }
    }
}

