/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ShaUtils {
    private ShaUtils() {
    }

    public static String computeSha256(Path path) throws IOException, NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            byte[] buffer = new byte[8192];
            int len = input.read(buffer);
            while (len != -1) {
                sha256.update(buffer, 0, len);
                len = input.read(buffer);
            }
            String string = ShaUtils.byteArrayToHexString(sha256.digest());
            return string;
        }
    }

    public static String computeSha256(String contents) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(contents.getBytes());
        return ShaUtils.byteArrayToHexString(sha256.digest());
    }

    private static String byteArrayToHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

