/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.util;

import gg.hoplite.mcup.meta.AgentMeta;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfJarUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfJarUtil.class);
    private static final String JAVA_BIN_PATH = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";

    public static Path getThisJarPath() throws CannotAccessJarException {
        Path path;
        URI uri;
        CodeSource codeSource = AgentMeta.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new CannotAccessJarException("Could not find code source");
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            throw new CannotAccessJarException("Could not get JAR URL");
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new CannotAccessJarException("Invalid URI: " + String.valueOf(url), e);
        }
        try {
            path = Path.of(uri);
        }
        catch (IllegalArgumentException | SecurityException | FileSystemNotFoundException e) {
            throw new CannotAccessJarException("Path could not be constructed from URI: " + String.valueOf(uri), e);
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new CannotAccessJarException("Path is not a JAR file: " + String.valueOf(path));
        }
        LOGGER.info("Found self path: {}", (Object)path);
        return path;
    }

    public static ProcessBuilder runJarBuilder(Path jarPath, List<String> jvmArgs, String ... programArgs) throws IOException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(JAVA_BIN_PATH);
        commandLine.addAll(jvmArgs);
        commandLine.add("-jar");
        commandLine.add(jarPath.toString());
        Collections.addAll(commandLine, programArgs);
        LOGGER.debug("Going to run {}", (Object)commandLine);
        return new ProcessBuilder(commandLine);
    }

    public static Process runJar(Path jarPath, List<String> jvmArgs, String ... programArgs) throws IOException {
        return SelfJarUtil.runJarBuilder(jarPath, jvmArgs, programArgs).start();
    }

    public static Process runJar(Path jarPath, String ... programArgs) throws IOException {
        return SelfJarUtil.runJar(jarPath, List.of(), programArgs);
    }

    public static ProcessBuilder copyAndRunSelf(String newName, String ... args) throws IOException, CannotAccessJarException {
        Path jarPath = SelfJarUtil.getThisJarPath();
        Path newPath = jarPath.resolveSibling(newName);
        Files.copy(jarPath, newPath, StandardCopyOption.REPLACE_EXISTING);
        return SelfJarUtil.runJarBuilder(newPath, List.of("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:5005"), args);
    }

    public static Process runSelf(String ... args) throws IOException, CannotAccessJarException {
        Path jarPath = SelfJarUtil.getThisJarPath();
        return SelfJarUtil.runJar(jarPath, List.of("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:5005"), args);
    }

    public static class CannotAccessJarException
    extends Exception {
        public CannotAccessJarException() {
        }

        public CannotAccessJarException(String message) {
            super(message);
        }

        public CannotAccessJarException(String message, Throwable cause) {
            super(message, cause);
        }

        public CannotAccessJarException(Throwable cause) {
            super(cause);
        }

        public CannotAccessJarException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

