/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import mjson.Json;

public class JsonUtil {
    public static Optional<String> getOptionalString(Json json, String key) throws JsonParseException {
        Json jString = json.at(key);
        if (jString == null) {
            return Optional.empty();
        }
        if (!jString.isString()) {
            return Optional.empty();
        }
        return Optional.of(jString.asString());
    }

    public static String getStringOrFail(Json json, String key) throws JsonParseException {
        Json jString = json.at(key);
        if (jString == null) {
            throw new JsonParseException("No such key " + key);
        }
        if (!jString.isString()) {
            throw new JsonParseException(key + " is not a string: " + String.valueOf(jString));
        }
        return jString.asString();
    }

    public static String getStringOrEmpty(Json json, String key) {
        Json jString = json.at(key);
        if (jString == null || !jString.isString()) {
            return "";
        }
        return jString.asString();
    }

    public static URI getUriOrFail(Json json, String key) {
        URI uri;
        String uriString = JsonUtil.getStringOrFail(json, key);
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new JsonParseException("Could not parse URI: " + uriString, e);
        }
        return uri;
    }

    public static boolean getBooleanOrFalse(Json json, String key) {
        Json jBool = json.at(key);
        if (jBool == null || !jBool.isBoolean()) {
            return false;
        }
        return jBool.asBoolean();
    }

    public static class JsonParseException
    extends RuntimeException {
        public JsonParseException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public JsonParseException(Throwable cause) {
            super(cause);
        }

        public JsonParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public JsonParseException(String message) {
            super(message);
        }

        public JsonParseException() {
        }
    }
}

