/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.util;

import com.github.mizosoft.methanol.internal.Utils;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IconUtil.class);
    private static final int ICON_RESOLUTIONS = 2;
    private static ImageIcon swingIcon = null;
    private static final int MODPACK_LOGO_RESOLUTIONS = 3;
    private static ImageIcon modpackLogo = null;

    public static String getProfileIcon() {
        String string;
        block9: {
            InputStream is = Utils.class.getClassLoader().getResourceAsStream("profile_icon.png");
            try {
                int len;
                byte[] ret = new byte[4096];
                int offset = 0;
                while ((len = is.read(ret, offset, ret.length - offset)) != -1) {
                    if ((offset += len) != ret.length) continue;
                    ret = Arrays.copyOf(ret, ret.length * 2);
                }
                string = "data:image/png;base64," + Base64.getEncoder().encodeToString(Arrays.copyOf(ret, offset));
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load profile icon", e);
                    return "TNT";
                }
            }
            is.close();
        }
        return string;
    }

    public static ImageIcon getSwingIcon() {
        if (swingIcon == null) {
            swingIcon = IconUtil.getMultiresolutionIcon("/installer_images/icon_%dx.png", 2);
        }
        return swingIcon;
    }

    public static ImageIcon getModpackLogo() {
        if (modpackLogo == null) {
            modpackLogo = IconUtil.getMultiresolutionIcon("/installer_images/hoplite_modpack_%dx.png", 3);
        }
        return modpackLogo;
    }

    private static ImageIcon getMultiresolutionIcon(String path, int resolutions) {
        try {
            Image[] images = new Image[resolutions];
            for (int i = 0; i < images.length; ++i) {
                int multiplier = (int)Math.pow(2.0, i);
                images[i] = ImageIO.read(IconUtil.class.getResource(path.formatted(multiplier)));
            }
            BaseMultiResolutionImage image = new BaseMultiResolutionImage(images);
            return new ImageIcon(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

