/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadUtil.class);
    private static Path tmpDir;

    private static Path getTmpDir() throws IOException {
        if (tmpDir == null) {
            LOGGER.debug("Creating tmp directory");
            tmpDir = Files.createTempDirectory("mcup-", new FileAttribute[0]);
            LOGGER.debug("Made tmp directory {}", (Object)tmpDir);
        }
        return tmpDir;
    }

    public static Path copyFileFromResources(String pathWithinJar, String name) throws IOException {
        Path outputPath = DownloadUtil.getTmpDir().resolve(name);
        try (InputStream stream = DownloadUtil.class.getResourceAsStream(pathWithinJar);){
            if (stream == null) {
                throw new NoSuchFileException(pathWithinJar);
            }
            LOGGER.debug("Copying file from resources {} to {}", (Object)pathWithinJar, (Object)outputPath);
            Files.copy(stream, outputPath, new CopyOption[0]);
        }
        LOGGER.debug("Copied file to {}", (Object)outputPath);
        return outputPath;
    }

    public static Path writeBytes(byte[] bytes, String name) throws IOException {
        Path outputPath = DownloadUtil.getTmpDir().resolve(name);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            LOGGER.debug("Copying file from bytes to {}", (Object)outputPath);
            Files.copy(stream, outputPath, new CopyOption[0]);
        }
        LOGGER.debug("Copied bytes to {}", (Object)outputPath);
        return outputPath;
    }
}

