/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.model;

import gg.hoplite.mcup.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import mjson.Json;

public record SubchannelInfo(String mcVersion, String loaderVersion, String updateUriPrefix, String unsupConfig, Optional<String> publicKey) {
    public static SubchannelInfo parseJson(Json json) throws JsonUtil.JsonParseException {
        String mcVersion = JsonUtil.getStringOrFail(json, "mcVersion");
        String loaderVersion = JsonUtil.getStringOrFail(json, "loaderVersion");
        String updateUriPrefix = JsonUtil.getStringOrFail(json, "updateUriPrefix");
        String unsupConfig = new String(Base64.getDecoder().decode(JsonUtil.getStringOrFail(json, "unsupConfig")), StandardCharsets.UTF_8);
        Optional<String> publicKey = JsonUtil.getOptionalString(json, "publicKey");
        return new SubchannelInfo(mcVersion, loaderVersion, updateUriPrefix, unsupConfig, publicKey);
    }

    public Json toJson(Json json) {
        json.set("mcVersion", (Object)this.mcVersion);
        json.set("loaderVersion", (Object)this.loaderVersion);
        json.set("updateUriPrefix", (Object)this.updateUriPrefix);
        json.set("unsupConfig", (Object)Base64.getEncoder().encodeToString(this.unsupConfig.getBytes(StandardCharsets.UTF_8)));
        this.publicKey.ifPresent(s -> json.set("publicKey", s));
        return json;
    }
}

