/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.model;

import gg.hoplite.mcup.util.JsonUtil;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import mjson.Json;

public interface PrismMetaInfo {

    public record Component(String uid, String name, Optional<String> version, boolean isVolatile, List<Requirement> requirements) {
        public static Component parseJson(Json json, Optional<String> version) {
            String uid = JsonUtil.getStringOrFail(json, "uid");
            String name = JsonUtil.getStringOrFail(json, "name");
            Json versionJson = json.at("versions").asJsonList().stream().filter(j -> version.isEmpty() || j.at("version").asString().equals(version.get())).findFirst().orElseThrow(() -> new NoSuchElementException("Could not find info for version %s of %s".formatted(version, uid)));
            boolean isVolatile = JsonUtil.getBooleanOrFalse(versionJson, "volatile");
            List<Requirement> requirements = Optional.ofNullable(versionJson.at("requires")).stream().flatMap(j -> j.asJsonList().stream()).map(Requirement::parseJson).toList();
            Optional<String> actualVersion = JsonUtil.getOptionalString(versionJson, "version");
            return new Component(uid, name, actualVersion, isVolatile, requirements);
        }

        public static Json toJson(Component cmp) {
            Json cmpJson = Json.object();
            cmpJson.set("cachedName", (Object)cmp.name());
            cmp.version.ifPresent(s -> cmpJson.set("cachedVersion", s));
            cmpJson.set("cachedVolatile", (Object)cmp.isVolatile());
            cmpJson.set("cachedRequires", Requirement.listToJson(cmp.requirements()));
            cmpJson.set("important", (Object)cmp.uid().equals("net.minecraft"));
            cmpJson.set("uid", (Object)cmp.uid());
            cmp.version.ifPresent(s -> cmpJson.set("version", s));
            cmpJson.set("dependencyOnly", (Object)(cmp.uid().equals("org.lwjgl3") || cmp.uid().equals("net.fabricmc.intermediary") ? 1 : 0));
            return cmpJson;
        }
    }

    public record Requirement(String uid, Optional<String> version) {
        public static Requirement parseJson(Json json) {
            String uid = JsonUtil.getStringOrFail(json, "uid");
            Optional<String> version = JsonUtil.getOptionalString(json, "suggests");
            return new Requirement(uid, version);
        }

        private Json toJson() {
            Json json = Json.object();
            json.set("uid", (Object)this.uid);
            this.version.ifPresent(s -> json.set("suggests", s));
            return json;
        }

        public static Json listToJson(List<Requirement> requirements) {
            Json result = Json.array();
            requirements.stream().map(Requirement::toJson).forEach(result::add);
            return result;
        }
    }
}

