/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.model;

import gg.hoplite.mcup.model.SubchannelInfo;
import gg.hoplite.mcup.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Optional;
import mjson.Json;

public record AgentConfig(String installName, Optional<String> installDisplayName, String subchannelName, SubchannelInfo subchannelInfo, Optional<String> workingDir) {
    public static AgentConfig parseB64(String agentArgs) throws JsonUtil.JsonParseException {
        try {
            return AgentConfig.parseBytes(Base64.getDecoder().decode(agentArgs));
        }
        catch (IllegalArgumentException e) {
            throw new JsonUtil.JsonParseException("Could not parse encoded config", e);
        }
    }

    private static AgentConfig parseBytes(byte[] bytes) throws JsonUtil.JsonParseException {
        return AgentConfig.parseJsonString(new String(bytes, StandardCharsets.UTF_8));
    }

    private static AgentConfig parseJsonString(String string) throws JsonUtil.JsonParseException {
        try {
            return AgentConfig.parseJson(Json.read(string));
        }
        catch (Json.MalformedJsonException e) {
            throw new JsonUtil.JsonParseException("Could not parse config", e);
        }
    }

    public static AgentConfig parseJson(Json json) throws JsonUtil.JsonParseException {
        String installName = JsonUtil.getStringOrFail(json, "installName");
        String subchannelName = JsonUtil.getStringOrFail(json, "subchannel");
        SubchannelInfo subchannelInfo = SubchannelInfo.parseJson(json);
        Optional<String> workingDir = JsonUtil.getOptionalString(json, "workingDir");
        Optional<String> installDisplayName = JsonUtil.getOptionalString(json, "installDisplayName");
        return new AgentConfig(installName, installDisplayName, subchannelName, subchannelInfo, workingDir);
    }

    public String toBase64() {
        return Base64.getEncoder().encodeToString(this.toJson().toString().getBytes(StandardCharsets.UTF_8));
    }

    private Json toJson() {
        Json json = Json.object();
        json.set("installName", (Object)this.installName);
        json.set("subchannel", (Object)this.subchannelName);
        this.subchannelInfo.toJson(json);
        this.workingDir.map(w -> json.set("workingDir", w));
        return json;
    }

    public AgentConfig withWorkingDir(Path dir) {
        return new AgentConfig(this.installName, this.installDisplayName, this.subchannelName, this.subchannelInfo, Optional.of(dir.toString()));
    }

    public AgentConfig withInstallName(String installName, String installDisplayName) {
        return new AgentConfig(installName, Optional.of(installDisplayName), this.subchannelName, this.subchannelInfo, this.workingDir);
    }
}

