/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.meta;

import com.github.mizosoft.methanol.Methanol;
import gg.hoplite.mcup.meta.AbstractMeta;
import gg.hoplite.mcup.model.AgentConfig;
import gg.hoplite.mcup.model.McupDownloadInfo;
import gg.hoplite.mcup.model.SubchannelInfo;
import gg.hoplite.mcup.util.DownloadUtil;
import gg.hoplite.mcup.util.SelfJarUtil;
import gg.hoplite.mcup.util.ShaUtils;
import gg.hoplite.mcup.util.SystemProperties;
import gg.hoplite.mcup.util.Verifier;
import java.io.IOException;
import java.net.http.HttpClient;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import mjson.Json;

public class UpdateMeta
extends AbstractMeta {
    public UpdateMeta(AgentConfig config, ExecutorService executor) {
        this(new String[]{config.subchannelInfo().updateUriPrefix()}, (Executor)executor);
    }

    public UpdateMeta(String[] metaServers) {
        this((Methanol)UpdateMeta.makeMethanol().build(), metaServers);
    }

    public UpdateMeta(String[] metaServers, Executor executor) {
        this(UpdateMeta.makeMethanol().executor(executor).build(), metaServers, executor);
    }

    public UpdateMeta(Methanol build, String[] metaServers) {
        this(build, metaServers, ForkJoinPool.commonPool());
    }

    public UpdateMeta(HttpClient httpClient, String[] metaServers, Executor executor) {
        super(httpClient, metaServers, executor);
    }

    public CompletableFuture<String> getLatestSubchannel() {
        if (SystemProperties.LATEST_SUBCHANNEL_OVERRIDE != null) {
            return CompletableFuture.completedFuture(SystemProperties.LATEST_SUBCHANNEL_OVERRIDE.trim());
        }
        return this.getWithFallbacks(base -> base + "latest_subchannel").thenApply(String::trim);
    }

    public CompletableFuture<SubchannelInfo> getSubchannelInfo(String subchannel, Optional<Verifier> verifier) {
        return ((CompletableFuture)((CompletableFuture)this.getWithFallbacks(base -> base + "subchannel/%s/info.json".formatted(subchannel)).thenCompose(this.verifySignature(verifier, "subchannel/%s/info.json.sig".formatted(subchannel), "Invalidly-signed subchannel info"))).thenApply(Json::read)).thenApply(SubchannelInfo::parseJson);
    }

    public CompletableFuture<Path> downloadAgent(Optional<Verifier> verifier) {
        if (SystemProperties.DONT_DOWNLOAD_AGENT) {
            try {
                return CompletableFuture.completedFuture(SelfJarUtil.getThisJarPath());
            }
            catch (SelfJarUtil.CannotAccessJarException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getMcupDownloadInfo(verifier).thenCompose(this::downloadAgent);
    }

    public CompletableFuture<McupDownloadInfo> getMcupDownloadInfo(Optional<Verifier> verifier) {
        return ((CompletableFuture)((CompletableFuture)this.getWithFallbacks(base -> base + "latest_mcup.json").thenCompose(this.verifySignature(verifier, "latest_mcup.json.sig", "Invalidly-signed latest_mcup.json"))).thenApply(Json::read)).thenApply(McupDownloadInfo::parseJson);
    }

    public CompletableFuture<Path> downloadAgent(McupDownloadInfo mcupDownloadInfo) {
        try {
            Path selfPath = SelfJarUtil.getThisJarPath();
            String hash = ShaUtils.computeSha256(selfPath);
            if (hash.equals(mcupDownloadInfo.path())) {
                LOGGER.info("We have the latest mcup jar, no need to download it");
                return CompletableFuture.completedFuture(selfPath);
            }
        }
        catch (SelfJarUtil.CannotAccessJarException | IOException | NoSuchAlgorithmException e) {
            LOGGER.info("Couldn't use self jar, going to download mcup", e);
            return this.downloadAgent(mcupDownloadInfo.path());
        }
        return this.downloadAgent(mcupDownloadInfo.path());
    }

    public CompletableFuture<Path> downloadAgent(String path) {
        return this.getBytesWithFallbacks(base -> base + path).thenApplyAsync(bytes -> {
            try {
                return DownloadUtil.writeBytes(bytes, "updated_mcup_agent.jar");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save downloaded mcup agent", e);
            }
        }, this.executor);
    }

    private Function<String, CompletionStage<String>> verifySignature(Optional<Verifier> verifier, String path, String message) {
        return str -> verifier.map(v -> this.getBytesWithFallbacks(base -> base + path).thenApply(sig -> {
            if (!v.verify((String)str, (byte[])sig)) {
                throw new RuntimeException(message);
            }
            return str;
        })).orElseGet(() -> CompletableFuture.completedFuture(str));
    }
}

