/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.meta;

import com.github.mizosoft.methanol.Methanol;
import gg.hoplite.mcup.meta.AbstractMeta;
import gg.hoplite.mcup.model.PrismMetaInfo;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import mjson.Json;

public class PrismMeta
extends AbstractMeta {
    private static final String[] DEFAULT_META_SERVERS = new String[]{"https://meta.prismlauncher.org/v1/"};

    public PrismMeta(Executor executor) {
        this(DEFAULT_META_SERVERS, executor);
    }

    public PrismMeta() {
        this(DEFAULT_META_SERVERS);
    }

    public PrismMeta(String extraMetaServer) {
        this((Methanol)PrismMeta.makeMethanol().build(), PrismMeta.prepend(extraMetaServer, DEFAULT_META_SERVERS));
    }

    public PrismMeta(String extraMetaServer, Executor executor) {
        this(PrismMeta.prepend(extraMetaServer, DEFAULT_META_SERVERS), executor);
    }

    public PrismMeta(String[] metaServers) {
        this((Methanol)PrismMeta.makeMethanol().build(), metaServers);
    }

    public PrismMeta(String[] metaServers, Executor executor) {
        this(PrismMeta.makeMethanol().executor(executor).build(), metaServers, executor);
    }

    public PrismMeta(Methanol build, String[] metaServers) {
        this(build, metaServers, ForkJoinPool.commonPool());
    }

    public PrismMeta(HttpClient httpClient, String[] metaServers, Executor executor) {
        super(httpClient, metaServers, executor);
    }

    private static String[] prepend(String item, String[] array) {
        String[] result = new String[array.length + 1];
        System.arraycopy(array, 0, result, 1, array.length);
        result[0] = item;
        return result;
    }

    public CompletableFuture<List<PrismMetaInfo.Component>> getComponents(String uid, Optional<String> version, Map<String, String> defaultVersions) {
        return ((CompletableFuture)((CompletableFuture)this.getWithFallbacks(base -> base + uid).thenApply(Json::read)).thenApply(j -> PrismMetaInfo.Component.parseJson(j, version))).thenCompose(c -> {
            ArrayList<PrismMetaInfo.Component> results = new ArrayList<PrismMetaInfo.Component>();
            results.add((PrismMetaInfo.Component)c);
            List<CompletableFuture> reqs = c.requirements().stream().map(req -> this.getComponents(req.uid(), req.version().or(() -> Optional.ofNullable((String)defaultVersions.get(req.uid()))), defaultVersions)).toList();
            return CompletableFuture.allOf(reqs.toArray(new CompletableFuture[0])).thenApply(v -> {
                results.addAll(reqs.stream().map(CompletableFuture::resultNow).flatMap(Collection::stream).toList());
                return results;
            });
        });
    }
}

