/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.meta;

import com.github.mizosoft.methanol.Methanol;
import gg.hoplite.mcup.meta.AbstractMeta;
import java.net.http.HttpClient;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import mjson.Json;

public class FabricMeta
extends AbstractMeta {
    private static final String[] DEFAULT_META_SERVERS = new String[]{"https://meta.fabricmc.net/", "https://meta2.fabricmc.net/", "https://meta3.fabricmc.net/"};

    public FabricMeta(Executor executor) {
        this(DEFAULT_META_SERVERS, executor);
    }

    public FabricMeta() {
        this(DEFAULT_META_SERVERS);
    }

    public FabricMeta(String[] metaServers) {
        this((Methanol)FabricMeta.makeMethanol().build(), metaServers);
    }

    public FabricMeta(String[] metaServers, Executor executor) {
        this(FabricMeta.makeMethanol().executor(executor).build(), metaServers, executor);
    }

    public FabricMeta(Methanol build, String[] metaServers) {
        this(build, metaServers, ForkJoinPool.commonPool());
    }

    public FabricMeta(HttpClient httpClient, String[] metaServers, Executor executor) {
        super(httpClient, metaServers, executor);
    }

    public CompletableFuture<Json> getProfile(String mcVersion, String loaderVersion) {
        return this.getWithFallbacks(base -> base + "v2/versions/loader/%s/%s/profile/json".formatted(mcVersion, loaderVersion)).thenApply(Json::read);
    }
}

