/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.meta;

import com.github.mizosoft.methanol.Methanol;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMeta {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractMeta.class);
    protected final HttpClient httpClient;
    protected final String[] metaServers;
    protected final Executor executor;

    public AbstractMeta(HttpClient httpClient, String[] metaServers, Executor executor) {
        this.httpClient = httpClient;
        this.metaServers = new String[metaServers.length];
        this.executor = executor;
        for (int i = 0; i < metaServers.length; ++i) {
            String metaServer = metaServers[i];
            this.metaServers[i] = metaServer.endsWith("/") ? metaServer : metaServer + "/";
        }
    }

    protected static Methanol.Builder makeMethanol() {
        return (Methanol.Builder)((Methanol.Builder)Methanol.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).userAgent("Hoplite MCUp (https://hoplite.gg)")).defaultHeader("Accept", "application/json");
    }

    protected CompletableFuture<String> getWithFallbacks(UnaryOperator<String> urlMaker) {
        return this.getWithFallbacks(urlMaker, HttpResponse.BodyHandlers.ofString());
    }

    protected CompletableFuture<byte[]> getBytesWithFallbacks(UnaryOperator<String> urlMaker) {
        return this.getWithFallbacks(urlMaker, HttpResponse.BodyHandlers.ofByteArray());
    }

    protected <T> CompletableFuture<T> getWithFallbacks(UnaryOperator<String> urlMaker, HttpResponse.BodyHandler<T> bodyHandler) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (String meta : this.metaServers) {
            URI uri = URI.create((String)urlMaker.apply(meta));
            CompletableFuture lastFuture = futures.isEmpty() ? CompletableFuture.failedFuture(new Throwable()) : (CompletableFuture)futures.getLast();
            futures.add(lastFuture.exceptionallyCompose(err -> {
                if (err.getMessage() != null) {
                    LOGGER.error("HTTP request failed", (Throwable)err);
                }
                LOGGER.info("Sending HTTP request to {} ", (Object)uri);
                return this.httpClient.sendAsync(HttpRequest.newBuilder(uri).GET().build(), bodyHandler).thenApply(hr -> {
                    LOGGER.info("Got response from {} (status {}) ", (Object)uri, (Object)hr.statusCode());
                    if (hr.statusCode() != 200) {
                        throw new RuntimeException("HTTP status " + hr.statusCode() + " for URL " + String.valueOf(uri));
                    }
                    return hr.body();
                });
            }));
        }
        return (CompletableFuture)futures.getLast();
    }
}

