/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.installer.vanilla;

import gg.hoplite.mcup.installer.AppFramework;
import gg.hoplite.mcup.installer.LauncherHandler;
import gg.hoplite.mcup.installer.UnsupInstaller;
import gg.hoplite.mcup.meta.FabricMeta;
import gg.hoplite.mcup.model.AgentConfig;
import gg.hoplite.mcup.util.IconUtil;
import gg.hoplite.mcup.util.OperatingSystem;
import gg.hoplite.mcup.util.Verifier;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import mjson.Json;

public class VanillaLauncherHandler
implements LauncherHandler {
    public static final String STANDARD_PROFILES_JSON_FILENAME = "launcher_profiles.json";
    public static final String XBOX_PROFILES_JSON_FILENAME = "launcher_profiles_microsoft_store.json";
    private static final String VERSIONS_DIR_PATH = "versions";
    private static final String RESERVED_PATH = "hoplite-reserved";
    private final String profilesJsonFilename;

    public VanillaLauncherHandler(String profilesJsonFilename) {
        this.profilesJsonFilename = profilesJsonFilename;
    }

    @Override
    public Stream<Path> potentialLauncherPaths() {
        Path home = Path.of(System.getProperty("user.home", "."), new String[0]);
        Path dotMinecraft = home.resolve(".minecraft");
        return switch (OperatingSystem.CURRENT) {
            default -> throw new MatchException(null, null);
            case OperatingSystem.WINDOWS -> {
                String appData = System.getenv("APPDATA");
                if (appData != null) {
                    Path appdataDotMinecraft = Path.of(appData, ".minecraft");
                    yield Stream.of(appdataDotMinecraft);
                }
                yield Stream.of(dotMinecraft);
            }
            case OperatingSystem.MACOS -> {
                Path applicationSupportMinecraft = home.resolve("Library").resolve("Application Support").resolve("minecraft");
                yield Stream.of(applicationSupportMinecraft);
            }
            case OperatingSystem.LINUX -> {
                Path flatpakDotMinecraft = home.resolve(".var").resolve("app").resolve("com.mojang.Minecraft").resolve(".minecraft");
                yield Stream.of(dotMinecraft, flatpakDotMinecraft);
            }
        };
    }

    @Override
    public boolean doesLauncherExistAt(Path potentialPath) {
        return Files.isDirectory(potentialPath, new LinkOption[0]) && Files.isRegularFile(potentialPath.resolve(this.profilesJsonFilename), new LinkOption[0]);
    }

    @Override
    public CompletableFuture<Void> install(AgentConfig agentConfig, Path launcherPath, AppFramework app) {
        return CompletableFuture.runAsync(() -> {
            try (AppFramework.Task tasks = app.start("installer.vanilla.task.installing").expect(6);){
                Json versionJson;
                AppFramework.Task task;
                Path agentPath;
                try (AppFramework.Task task2 = tasks.start("installer.vanilla.task.launcherclose", new Object[0]);){
                    if (!app.checkLauncherIsntRunning()) {
                        throw new CancellationException();
                    }
                }
                Optional<Verifier> verifier = agentConfig.subchannelInfo().publicKey().map(Verifier::create);
                String versionId = agentConfig.installName() + "-" + agentConfig.subchannelInfo().loaderVersion() + "-" + agentConfig.subchannelInfo().mcVersion();
                Path hopliteDataDirPath = launcherPath.resolve(RESERVED_PATH).resolve(agentConfig.installName());
                try (AppFramework.Task task3 = tasks.start("installer.vanilla.task.mcup", new Object[0]);){
                    Files.createDirectories(hopliteDataDirPath, new FileAttribute[0]);
                    Path agentSrcPath = app.updateMeta().downloadAgent(verifier).join();
                    agentPath = hopliteDataDirPath.resolve("mcup.jar");
                    Files.copy(agentSrcPath, agentPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to save MCUP agent", e);
                }
                try (AppFramework.Task task4 = tasks.start("installer.vanilla.task.unsup", new Object[0]);){
                    Path unsupSrcPath = app.agentMeta().downloadUnsup().join();
                    Path unsupPath = hopliteDataDirPath.resolve("unsup.jar");
                    Files.copy(unsupSrcPath, unsupPath, StandardCopyOption.REPLACE_EXISTING);
                    Path unsupLicenseSrcPath = app.agentMeta().downloadUnsupLicense().join();
                    Path unsupLicensePath = hopliteDataDirPath.resolve("unsup_license.txt");
                    Files.copy(unsupLicenseSrcPath, unsupLicensePath, StandardCopyOption.REPLACE_EXISTING);
                    Path unsupIniPath = hopliteDataDirPath.resolve("unsup.ini");
                    String unsupConfig = UnsupInstaller.addFlavors(agentConfig.subchannelInfo().unsupConfig());
                    Files.writeString(unsupIniPath, (CharSequence)unsupConfig, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to save unsup agent", e);
                }
                try {
                    task = tasks.start("installer.vanilla.task.version.download", new Object[0]);
                    try {
                        versionJson = this.getVersionJson(agentConfig.subchannelInfo().mcVersion(), agentConfig.subchannelInfo().loaderVersion(), app.fabricMeta());
                        this.patchVersionJson(versionJson, versionId, hopliteDataDirPath.resolve("mods"), agentPath, agentConfig);
                    }
                    finally {
                        if (task != null) {
                            task.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to download version definition", e);
                }
                try {
                    task = tasks.start("installer.vanilla.task.version.install", new Object[0]);
                    try {
                        Path versionDir = launcherPath.resolve(VERSIONS_DIR_PATH).resolve(versionId);
                        Path versionJsonPath = versionDir.resolve(versionId + ".json");
                        Path versionDummyJarPath = versionDir.resolve(versionId + ".jar");
                        Files.createDirectories(versionDir, new FileAttribute[0]);
                        try {
                            Files.createFile(versionDummyJarPath, new FileAttribute[0]);
                        }
                        catch (FileAlreadyExistsException unsupConfig) {
                            // empty catch block
                        }
                        Files.writeString(versionJsonPath, (CharSequence)versionJson.toString(), new OpenOption[0]);
                    }
                    finally {
                        if (task != null) {
                            task.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to save version definition", e);
                }
                try {
                    task = tasks.start("installer.vanilla.task.profile", new Object[0]);
                    try {
                        Json profileEntry;
                        Path profilesJsonPath = launcherPath.resolve(this.profilesJsonFilename);
                        Json profilesJson = Json.read(Files.readString(profilesJsonPath));
                        Json profiles = profilesJson.at("profiles");
                        if (profiles == null) {
                            profiles = Json.object();
                            profilesJson.set("profiles", profiles);
                        }
                        if ((profileEntry = profiles.at(agentConfig.installName())) == null) {
                            profileEntry = VanillaLauncherHandler.createProfile(agentConfig.installDisplayName().orElse(agentConfig.installName()));
                            profiles.set(agentConfig.installName(), profileEntry);
                        }
                        profileEntry.set("lastVersionId", (Object)versionId);
                        Files.writeString(profilesJsonPath, (CharSequence)profilesJson.toString(), new OpenOption[0]);
                    }
                    finally {
                        if (task != null) {
                            task.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create launcher profile", e);
                }
            }
        }, app);
    }

    private Json getVersionJson(String mcVersion, String loaderVersion, FabricMeta fabricMeta) {
        CompletableFuture<Json> versionJsonFut = fabricMeta.getProfile(mcVersion, loaderVersion);
        return versionJsonFut.join();
    }

    private void patchVersionJson(Json json, String versionId, Path modsFolder, Path agentPath, AgentConfig agentConfig) {
        json.set("id", (Object)versionId);
        Json jvmArgs = json.at("arguments", Json.object()).at("jvm", Json.array());
        jvmArgs.add("-Dfabric.modsFolder=" + String.valueOf(modsFolder.toAbsolutePath()));
        jvmArgs.add("-javaagent:%s=%s".formatted(agentPath, agentConfig.toBase64()));
    }

    private static Json createProfile(String name) {
        Json jsonObject = Json.object();
        jsonObject.set("name", (Object)name);
        jsonObject.set("type", (Object)"custom");
        jsonObject.set("created", (Object)DateTimeFormatter.ISO_INSTANT.format(Instant.now()));
        jsonObject.set("lastUsed", (Object)DateTimeFormatter.ISO_INSTANT.format(Instant.EPOCH));
        jsonObject.set("icon", (Object)IconUtil.getProfileIcon());
        return jsonObject;
    }
}

