/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.installer.prism;

import gg.hoplite.mcup.installer.prism.AbstractPrismlikeLauncherHandler;
import gg.hoplite.mcup.util.OperatingSystem;
import java.nio.file.Path;
import java.util.stream.Stream;

public class PrismLauncherHandler
extends AbstractPrismlikeLauncherHandler {
    public PrismLauncherHandler() {
        super("Prism Launcher", "prismlauncher.cfg");
    }

    @Override
    public Stream<Path> potentialLauncherPaths() {
        Path home = Path.of(System.getProperty("user.home", "."), new String[0]);
        return switch (OperatingSystem.CURRENT) {
            default -> throw new MatchException(null, null);
            case OperatingSystem.WINDOWS -> {
                Path scoopPrism = home.resolve("scoop").resolve("persist").resolve("prismlauncher");
                String appData = System.getenv("APPDATA");
                if (appData != null) {
                    Path appdataPrism = Path.of(appData, "PrismLauncher");
                    yield Stream.of(appdataPrism, scoopPrism);
                }
                yield Stream.of(scoopPrism);
            }
            case OperatingSystem.MACOS -> {
                Path applicationSupportPrism = home.resolve("Library").resolve("Application Support").resolve("PrismLauncher");
                yield Stream.of(applicationSupportPrism);
            }
            case OperatingSystem.LINUX -> {
                Path localSharePrism = home.resolve(".local").resolve("share").resolve("PrismLauncher");
                Path flatpakPrism = home.resolve(".var").resolve("app").resolve("org.prismlauncher.PrismLauncher").resolve("data").resolve("PrismLauncher");
                yield Stream.of(localSharePrism, flatpakPrism);
            }
        };
    }
}

