/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.installer.prism;

import gg.hoplite.mcup.installer.AppFramework;
import gg.hoplite.mcup.installer.LauncherHandler;
import gg.hoplite.mcup.installer.UnsupInstaller;
import gg.hoplite.mcup.meta.PrismMeta;
import gg.hoplite.mcup.model.AgentConfig;
import gg.hoplite.mcup.model.PrismMetaInfo;
import gg.hoplite.mcup.util.DownloadUtil;
import gg.hoplite.mcup.util.IconUtil;
import gg.hoplite.mcup.util.Verifier;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import mjson.Json;

public abstract class AbstractPrismlikeLauncherHandler
implements LauncherHandler {
    public static final String INSTANCES_DIR_PATH = "instances";
    private static final String RESERVED_PATH = "hoplite-reserved";
    private final String launcherName;
    private final String launcherCfgFilename;

    public AbstractPrismlikeLauncherHandler(String launcherName, String launcherCfgFilename) {
        this.launcherName = launcherName;
        this.launcherCfgFilename = launcherCfgFilename;
    }

    @Override
    public abstract Stream<Path> potentialLauncherPaths();

    @Override
    public boolean doesLauncherExistAt(Path potentialPath) {
        return Files.isDirectory(potentialPath, new LinkOption[0]) && Files.isDirectory(potentialPath.resolve(INSTANCES_DIR_PATH), new LinkOption[0]);
    }

    @Override
    public CompletableFuture<Void> install(AgentConfig agentConfig, Path launcherPath, AppFramework app) {
        return CompletableFuture.runAsync(() -> {
            try (AppFramework.Task tasks = app.start("installer.prism.task.installing").expect(7);){
                Json mmcPackJson;
                AppFramework.Task task;
                Optional<String> metaOverride;
                AppFramework.Task task2 = tasks.start("installer.prism.task.launcherclose", this.launcherName);
                if (task2 != null) {
                    task2.close();
                }
                Optional<Verifier> verifier = agentConfig.subchannelInfo().publicKey().map(Verifier::create);
                Path installPath = launcherPath.resolve(INSTANCES_DIR_PATH).resolve(agentConfig.installName());
                String versionId = agentConfig.installName() + "-" + agentConfig.subchannelInfo().loaderVersion() + "-" + agentConfig.subchannelInfo().mcVersion();
                Path librariesDirPath = installPath.resolve("libraries");
                Path patchesDirPath = installPath.resolve("patches");
                Path dotMinecraftPath = installPath.resolve(".minecraft");
                try (AppFramework.Task task3 = tasks.start("installer.prism.task.mcup", new Object[0]);){
                    Files.createDirectories(librariesDirPath, new FileAttribute[0]);
                    Path agentSrcPath = app.updateMeta().downloadAgent(verifier).join();
                    Path agentPath = librariesDirPath.resolve("mcup.jar");
                    Files.copy(agentSrcPath, agentPath, StandardCopyOption.REPLACE_EXISTING);
                    Json agentPatchJson = this.makeAgentPatchJson("gg.hoplite", "mcup", "MCup", agentConfig.withWorkingDir(dotMinecraftPath).toBase64());
                    Files.createDirectories(patchesDirPath, new FileAttribute[0]);
                    Path agentPatchPath = patchesDirPath.resolve("gg.hoplite.mcup.json");
                    Files.writeString(agentPatchPath, (CharSequence)agentPatchJson.toString(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to save MCUP agent", e);
                }
                try (AppFramework.Task task4 = tasks.start("installer.prism.task.unsup", new Object[0]);){
                    Path unsupSrcPath = app.agentMeta().downloadUnsup().join();
                    Path unsupPath = librariesDirPath.resolve("unsup.jar");
                    Files.copy(unsupSrcPath, unsupPath, StandardCopyOption.REPLACE_EXISTING);
                    Files.createDirectories(dotMinecraftPath, new FileAttribute[0]);
                    Path unsupLicenseSrcPath = app.agentMeta().downloadUnsupLicense().join();
                    Path unsupLicensePath = dotMinecraftPath.resolve("unsup_license.txt");
                    Files.copy(unsupLicenseSrcPath, unsupLicensePath, StandardCopyOption.REPLACE_EXISTING);
                    Path unsupIniPath = dotMinecraftPath.resolve("unsup.ini");
                    String unsupConfig = UnsupInstaller.addFlavors(agentConfig.subchannelInfo().unsupConfig());
                    Files.writeString(unsupIniPath, (CharSequence)unsupConfig, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to save unsup agent", e);
                }
                try (AppFramework.Task task5 = tasks.start("installer.prism.task.metaurl", new Object[0]);){
                    Path launcherCfg = launcherPath.resolve(this.launcherCfgFilename);
                    try (Stream<String> lines = Files.lines(launcherCfg);){
                        metaOverride = lines.filter(s -> s.startsWith("MetaURLOverride=")).map(l -> l.substring("MetaURLOverride=".length())).findFirst();
                    }
                    catch (IOException e) {
                        metaOverride = Optional.empty();
                    }
                }
                try {
                    task = tasks.start("installer.prism.task.version.download", new Object[0]);
                    try {
                        mmcPackJson = this.getMmcPackJson(agentConfig.subchannelInfo().mcVersion(), agentConfig.subchannelInfo().loaderVersion(), app.makePrismMeta(metaOverride), new PrismMetaInfo.Component("gg.hoplite.mcup", "MCUp", Optional.empty(), false, List.of()));
                    }
                    finally {
                        if (task != null) {
                            task.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to download version definition", e);
                }
                try {
                    task = tasks.start("installer.prism.task.version.install", new Object[0]);
                    try {
                        Path mmcPackPath = installPath.resolve("mmc-pack.json");
                        try {
                            Files.createFile(mmcPackPath, new FileAttribute[0]);
                        }
                        catch (FileAlreadyExistsException unsupIniPath) {
                            // empty catch block
                        }
                        Files.writeString(mmcPackPath, (CharSequence)mmcPackJson.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    }
                    finally {
                        if (task != null) {
                            task.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to save version definition", e);
                }
                try {
                    task = tasks.start("installer.prism.task.profile", new Object[0]);
                    try {
                        List<String> instanceCfgLines;
                        String iconName = "Hoplite";
                        Path iconPath = launcherPath.resolve("icons").resolve(iconName + ".png");
                        if (!Files.exists(iconPath, new LinkOption[0])) {
                            Path tmpIconPath = DownloadUtil.copyFileFromResources("/profile_icon.png", "Hoplite.png");
                            Files.createDirectories(iconPath.getParent(), new FileAttribute[0]);
                            Files.copy(tmpIconPath, iconPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        Path instanceCfgPath = installPath.resolve("instance.cfg");
                        try {
                            instanceCfgLines = Files.readAllLines(instanceCfgPath);
                        }
                        catch (IOException e) {
                            instanceCfgLines = new ArrayList<String>();
                        }
                        if (instanceCfgLines.isEmpty()) {
                            instanceCfgLines.add("[General]");
                            instanceCfgLines.add("InstanceType=OneSix");
                            instanceCfgLines.add("name=" + agentConfig.installDisplayName().orElse(agentConfig.installName()));
                            instanceCfgLines.add("iconKey=" + iconName);
                        }
                        Files.writeString(instanceCfgPath, (CharSequence)String.join((CharSequence)System.lineSeparator(), instanceCfgLines), new OpenOption[0]);
                    }
                    finally {
                        if (task != null) {
                            task.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create launcher profile", e);
                }
            }
        }, app);
    }

    private Json makeAgentPatchJson(String agentGroup, String agentId, String agentName, String argument) {
        Json jsonObject = Json.object();
        jsonObject.set("formatVersion", (Object)1);
        jsonObject.set("uid", (Object)(agentGroup + "." + agentId));
        jsonObject.set("name", (Object)agentName);
        Json agentObject = Json.object();
        agentObject.set("name", (Object)(agentGroup + ":" + agentId + ":1"));
        agentObject.set("MMC-hint", (Object)"local");
        agentObject.set("MMC-filename", (Object)(agentId + ".jar"));
        agentObject.set("MMC-displayname", (Object)agentName);
        agentObject.set("argument", (Object)argument);
        Json agentList = Json.array(agentObject);
        jsonObject.set("+agents", agentList);
        return jsonObject;
    }

    private Json getMmcPackJson(String mcVersion, String loaderVersion, PrismMeta prismMeta, PrismMetaInfo.Component ... extraComponents) {
        Json json = Json.object();
        Json components = Json.array();
        CompletableFuture<List<PrismMetaInfo.Component>> mcFut = prismMeta.getComponents("net.minecraft", Optional.of(mcVersion), Map.of("net.fabricmc.intermediary", mcVersion));
        CompletableFuture<List<PrismMetaInfo.Component>> fabricFut = prismMeta.getComponents("net.fabricmc.fabric-loader", Optional.of(loaderVersion), Map.of("net.fabricmc.intermediary", mcVersion));
        CompletableFuture.allOf(mcFut, fabricFut).join();
        Stream.concat(Stream.concat(mcFut.resultNow().stream(), fabricFut.resultNow().stream()), Arrays.stream(extraComponents)).forEach(cmp -> {
            Json cmpJson = PrismMetaInfo.Component.toJson(cmp);
            components.add(cmpJson);
        });
        json.set("components", components);
        json.set("formatVersion", (Object)1);
        return json;
    }

    private void patchVersionJson(Json json, String versionId, Path modsFolder, Path agentPath, AgentConfig agentConfig) {
        json.set("id", (Object)versionId);
        Json jvmArgs = json.at("arguments", Json.object()).at("jvm", Json.array());
        jvmArgs.add("-Dfabric.modsFolder=" + String.valueOf(modsFolder.toAbsolutePath()));
        jvmArgs.add("-javaagent:%s=%s".formatted(agentPath, agentConfig.toBase64()));
    }

    private static Json createProfile(String name) {
        Json jsonObject = Json.object();
        jsonObject.set("name", (Object)name);
        jsonObject.set("type", (Object)"custom");
        jsonObject.set("created", (Object)DateTimeFormatter.ISO_INSTANT.format(Instant.now()));
        jsonObject.set("lastUsed", (Object)DateTimeFormatter.ISO_INSTANT.format(Instant.EPOCH));
        jsonObject.set("icon", (Object)IconUtil.getProfileIcon());
        return jsonObject;
    }
}

