/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.installer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.installer.launcher.NativesHelper;

public class UnsupInstaller {
    private static final Set<String> SUPPORTED_OS_IDS = new HashSet<String>();

    public static String addFlavors(String unsupConfig) {
        Map<String, String> flavors = UnsupInstaller.makeDefaultFlavors();
        String flavorSection = String.format("\n[flavors]\n%s\n", flavors.entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining("\n")));
        return unsupConfig + flavorSection;
    }

    public static Map<String, String> makeDefaultFlavors() {
        String id = NativesHelper.getNormalisedOsId();
        if (!SUPPORTED_OS_IDS.contains(id)) {
            throw new RuntimeException("Unsupported platform: " + id);
        }
        HashMap<String, String> defaultFlavors = new HashMap<String, String>();
        defaultFlavors.put("platform", id);
        return defaultFlavors;
    }

    static {
        SUPPORTED_OS_IDS.add("windows-x86_64");
        SUPPORTED_OS_IDS.add("macos-x86_64");
        SUPPORTED_OS_IDS.add("macos-aarch64");
        SUPPORTED_OS_IDS.add("linux-x86_64");
    }
}

