/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.installer;

import gg.hoplite.mcup.installer.AppFramework;
import gg.hoplite.mcup.installer.Launcher;
import gg.hoplite.mcup.installer.LauncherType;
import gg.hoplite.mcup.model.AgentConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface LauncherHandler {
    public Stream<Path> potentialLauncherPaths();

    public boolean doesLauncherExistAt(Path var1);

    public CompletableFuture<Void> install(AgentConfig var1, Path var2, AppFramework var3);

    public static List<Launcher> getLaunchers() {
        ArrayList<Launcher> res = new ArrayList<Launcher>();
        for (LauncherType launcherType : LauncherType.values()) {
            launcherType.handler.potentialLauncherPaths().filter(launcherType.handler::doesLauncherExistAt).map(p -> new Launcher(launcherType, (Path)p)).forEach(res::add);
        }
        return res;
    }

    public static List<Launcher> getLaunchersForDirectory(Path directory) {
        return LauncherHandler.getLaunchersForDirectory(directory, new ArrayList<Launcher>());
    }

    private static List<Launcher> getLaunchersForDirectory(Path directory, List<Launcher> accum) {
        Path parent;
        for (LauncherType launcherType : LauncherType.values()) {
            if (!launcherType.handler.doesLauncherExistAt(directory)) continue;
            accum.add(new Launcher(launcherType, directory));
        }
        if (accum.isEmpty() && (parent = directory.getParent()) != null) {
            LauncherHandler.getLaunchersForDirectory(parent, accum);
        }
        return accum;
    }
}

