/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.installer;

import gg.hoplite.mcup.installer.LauncherType;
import gg.hoplite.mcup.util.Lang;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public record Launcher(LauncherType launcherType, Path path) {
    public static List<Launcher> parseString(String value) {
        String[] splits = value.split(File.pathSeparator);
        ArrayList<Launcher> result = new ArrayList<Launcher>();
        for (int i = 0; i < splits.length - 1; ++i) {
            LauncherType type = LauncherType.valueOf(splits[i++].toUpperCase(Locale.ROOT));
            Path path = Path.of(splits[i], new String[0]);
            result.add(new Launcher(type, path));
        }
        return result;
    }

    public static String toString(List<Launcher> launchers) {
        return launchers.stream().map(l -> l.launcherType.name() + File.pathSeparator + l.path.toString()).collect(Collectors.joining(File.pathSeparator));
    }

    @Override
    public String toString() {
        return Lang.get("launcher.installedat", this.launcherType.friendlyName(), this.path);
    }

    public String toShortString() {
        return this.launcherType.friendlyName();
    }
}

