/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.app;

import gg.hoplite.mcup.app.InstallerForm;
import gg.hoplite.mcup.app.LauncherSelectionDialog;
import gg.hoplite.mcup.app.SettingsDialog;
import gg.hoplite.mcup.app.UpdaterForm;
import gg.hoplite.mcup.util.IconUtil;
import gg.hoplite.mcup.util.Lang;
import java.awt.Component;
import java.awt.Taskbar;
import java.awt.Window;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallerGui {
    private static final Logger LOGGER = LoggerFactory.getLogger("Hoplite Installer GUI");
    private static InstallerForm installerForm;
    private static LauncherSelectionDialog launcherSelection;
    private static SettingsDialog settings;
    private static UpdaterForm updaterForm;

    public static void start() throws UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        System.setProperty("apple.awt.application.name", Lang.get("app.name", new Object[0]));
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        String lafCls = UIManager.getSystemLookAndFeelClassName();
        UIManager.setLookAndFeel(lafCls);
        InstallerGui.doTaskbarThing(tb -> tb.setIconImage(IconUtil.getSwingIcon().getImage()));
    }

    public static void openLauncherSelection() {
        if (launcherSelection != null && launcherSelection.isVisible()) {
            return;
        }
        launcherSelection = new LauncherSelectionDialog();
        if (installerForm != null) {
            launcherSelection.setLocationRelativeTo(installerForm);
        } else {
            launcherSelection.setLocationRelativeTo(null);
        }
        launcherSelection.setVisible(true);
    }

    public static void openInstallerForm() {
        if (installerForm == null) {
            installerForm = new InstallerForm();
        }
        installerForm.setVisible(true);
    }

    public static void openUpdaterForm() {
        if (updaterForm == null) {
            updaterForm = new UpdaterForm();
        }
        updaterForm.setVisible(true);
    }

    public static void openSettingsDialog() {
        if (settings != null && settings.isVisible()) {
            return;
        }
        settings = new SettingsDialog();
        if (installerForm != null) {
            settings.setLocationRelativeTo(installerForm);
        } else {
            settings.setLocationRelativeTo(null);
        }
        settings.setVisible(true);
    }

    public static void setProgressBar(double progress) {
        LOGGER.info("Progress: {}%", (Object)(progress * 100.0));
        if (installerForm != null) {
            installerForm.setProgressBar(progress);
        }
        if (updaterForm != null) {
            updaterForm.setProgressBar(progress);
        }
        InstallerGui.setTaskbarProgress(progress);
    }

    public static void setProgressMessage(String message, Object ... args) {
        String formattedMessage = Lang.get(message, args);
        LOGGER.info("Progress message: {}", (Object)formattedMessage);
        if (installerForm != null) {
            installerForm.setProgressMessage(formattedMessage);
        }
        if (updaterForm != null) {
            updaterForm.setProgressMessage(formattedMessage);
        }
    }

    public static void clearProgress() {
        InstallerGui.setProgressBar(1.0);
        InstallerGui.setProgressMessage("progress.done", new Object[0]);
        InstallerGui.doTaskbarThing(tb -> tb.setProgressValue(-1));
    }

    public static void startInstalling() {
        if (installerForm != null) {
            installerForm.setInstalling(true);
        }
        if (updaterForm != null) {
            updaterForm.setUpdating(true);
        }
    }

    public static void error(String title, String message) {
        InstallerGui.setProgressBar(0.0);
        InstallerGui.setProgressMessage("progress.error", new Object[0]);
        InstallerGui.setTaskbarError();
        LOGGER.error("{}{}", (Object)title, (Object)message);
        JOptionPane.showMessageDialog(installerForm, message, title, 0);
    }

    public static void doneInstall() {
        InstallerGui.doTaskbarThing(tb -> tb.requestUserAttention(true, false));
        JOptionPane.showMessageDialog(installerForm, Lang.get("dialog.installed.message", new Object[0]));
    }

    public static void doneUpdate() {
        InstallerGui.doTaskbarThing(tb -> tb.requestUserAttention(true, false));
        JOptionPane.showMessageDialog(updaterForm, Lang.get("dialog.updated.message", new Object[0]));
    }

    private static Optional<Window> getMainWindow() {
        return Stream.of(installerForm, updaterForm).filter(Objects::nonNull).filter(Component::isVisible).findFirst().map(Window.class::cast);
    }

    private static void setTaskbarProgress(double progress) {
        int progressPercent = (int)(progress * 100.0);
        InstallerGui.doTaskbarThing(tb -> InstallerGui.getMainWindow().filter($ -> tb.isSupported(Taskbar.Feature.PROGRESS_VALUE_WINDOW)).ifPresentOrElse(w -> tb.setWindowProgressValue((Window)w, progressPercent), () -> tb.setProgressValue(progressPercent)));
    }

    private static void setTaskbarError() {
        InstallerGui.doTaskbarThing(tb -> {
            InstallerGui.getMainWindow().filter($ -> tb.isSupported(Taskbar.Feature.PROGRESS_STATE_WINDOW)).ifPresentOrElse(w -> tb.setWindowProgressState((Window)w, Taskbar.State.ERROR), () -> tb.setProgressValue(-1));
            tb.requestUserAttention(true, true);
        });
    }

    private static void doTaskbarThing(Consumer<Taskbar> thingToDo) {
        try {
            thingToDo.accept(Taskbar.getTaskbar());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

