/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.app;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import gg.hoplite.mcup.app.App;
import gg.hoplite.mcup.app.InstallerGui;
import gg.hoplite.mcup.installer.Launcher;
import gg.hoplite.mcup.util.IconUtil;
import gg.hoplite.mcup.util.Lang;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class InstallerForm
extends JFrame {
    private JProgressBar progressBar;
    private JLabel icon;
    private JButton installButton;
    private JPanel contentPane;
    private JButton changeButton;
    private JLabel installingToLabel;
    private JButton settingsButton;
    private static Method $$$cachedGetBundleMethod$$$ = null;

    public InstallerForm() throws HeadlessException {
        this.$$$setupUI$$$();
        this.setup();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(3);
        this.setIconImage(IconUtil.getSwingIcon().getImage());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void setup() {
        this.setupAppState();
        this.changeButton.addActionListener(e -> {
            InstallerGui.openLauncherSelection();
            this.setupAppState();
        });
        if (App.APP.launcherInstalls.size() <= 1) {
            this.changeButton.setEnabled(false);
        }
        this.installButton.addActionListener(e -> App.APP.install());
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.icon.setIcon(IconUtil.getSwingIcon());
        this.settingsButton.addActionListener(e -> InstallerGui.openSettingsDialog());
    }

    private void setupAppState() {
        Launcher selectedLauncher = App.APP.selectedLauncher;
        if (selectedLauncher == null) {
            this.installingToLabel.setText(Lang.get("window.installer.message.nolauncher", new Object[0]));
            this.installButton.setEnabled(false);
        } else {
            this.installingToLabel.setText(Lang.get("window.installer.message.selectedlauncher", App.APP.presetAgentConfig.installDisplayName().orElse(App.APP.presetAgentConfig.installName()), selectedLauncher.toShortString()));
            this.installButton.setEnabled(true);
        }
    }

    public void setProgressBar(double progress) {
        this.progressBar.setValue((int)(progress * 100.0));
    }

    public void setProgressMessage(String message) {
        this.installButton.setText(message.isBlank() ? "Install" : message);
    }

    public void setInstalling(boolean value) {
        this.installButton.setEnabled(!value);
        this.changeButton.setEnabled(!value);
        if (!value) {
            this.setProgressMessage("");
        }
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridLayoutManager(6, 3, new Insets(0, 10, 10, 10), -1, -1));
        this.progressBar = new JProgressBar();
        this.progressBar.setBorderPainted(true);
        this.progressBar.setValue(0);
        this.contentPane.add((Component)this.progressBar, new GridConstraints(5, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        this.icon = new JLabel();
        this.icon.setHorizontalAlignment(0);
        this.icon.setHorizontalTextPosition(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/installer_images/hoplite_modpack_1x.png")));
        this.icon.setText("");
        this.contentPane.add((Component)this.icon, new GridConstraints(0, 1, 1, 1, 1, 0, 0, 0, new Dimension(256, 256), new Dimension(256, 256), new Dimension(256, 256), 0, false));
        this.installButton = new JButton();
        this.$$$loadButtonText$$$(this.installButton, this.$$$getMessageFromBundle$$$("lang/mcup", "window.installer.button.install"));
        this.contentPane.add((Component)this.installButton, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.contentPane.add((Component)spacer1, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.installingToLabel = new JLabel();
        this.$$$loadLabelText$$$(this.installingToLabel, this.$$$getMessageFromBundle$$$("lang/mcup", "window.installer.message.installingto"));
        panel1.add((Component)this.installingToLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.settingsButton = new JButton();
        this.$$$loadButtonText$$$(this.settingsButton, this.$$$getMessageFromBundle$$$("lang/mcup", "window.installer.button.settings"));
        panel2.add((Component)this.settingsButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.changeButton = new JButton();
        this.$$$loadButtonText$$$(this.changeButton, this.$$$getMessageFromBundle$$$("lang/mcup", "window.installer.button.change"));
        panel2.add((Component)this.changeButton, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, this.$$$getMessageFromBundle$$$("lang/mcup", "window.installer.label.message"));
        this.contentPane.add((Component)label1, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
    }

    private String $$$getMessageFromBundle$$$(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if ($$$cachedGetBundleMethod$$$ == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                $$$cachedGetBundleMethod$$$ = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)$$$cachedGetBundleMethod$$$.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

