/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.app;

import gg.hoplite.mcup.app.InstallerGui;
import gg.hoplite.mcup.app.TaskImpl;
import gg.hoplite.mcup.installer.AppFramework;
import gg.hoplite.mcup.installer.Launcher;
import gg.hoplite.mcup.installer.LauncherHandler;
import gg.hoplite.mcup.meta.AgentMeta;
import gg.hoplite.mcup.meta.FabricMeta;
import gg.hoplite.mcup.meta.PrismMeta;
import gg.hoplite.mcup.meta.UpdateMeta;
import gg.hoplite.mcup.model.AgentConfig;
import gg.hoplite.mcup.model.SubchannelInfo;
import gg.hoplite.mcup.util.Lang;
import gg.hoplite.mcup.util.Verifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import javax.swing.JOptionPane;
import mjson.Json;
import net.fabricmc.installer.launcher.MojangLauncherHelperWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
implements AppFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger("Hoplite Installer");
    public static App APP;
    private static final AgentConfig DEFAULT_AGENT_CONFIG;
    private final ExecutorService executor;
    private final FabricMeta fabricMeta;
    private final AgentMeta agentMeta;
    private final UpdateMeta updateMeta;
    protected Launcher selectedLauncher;
    protected final List<Launcher> launcherInstalls;
    protected AgentConfig presetAgentConfig;
    protected final boolean updateMode;
    protected CompletableFuture<Void> updatedAgentConfigFuture;

    public App(List<Launcher> launchers, AgentConfig agentConfig, boolean updateMode) {
        this.launcherInstalls = launchers != null ? launchers : LauncherHandler.getLaunchers();
        this.presetAgentConfig = agentConfig != null ? agentConfig : DEFAULT_AGENT_CONFIG;
        this.executor = Executors.newVirtualThreadPerTaskExecutor();
        this.fabricMeta = new FabricMeta(this.executor);
        this.agentMeta = new AgentMeta();
        this.updateMeta = new UpdateMeta(this.presetAgentConfig, this.executor);
        this.updateMode = updateMode;
        APP = this;
    }

    private void start() throws Exception {
        InstallerGui.start();
        if (this.launcherInstalls.isEmpty()) {
            InstallerGui.error(Lang.get("error.nolaunchers.title", new Object[0]), Lang.get("error.nolaunchers.message", new Object[0]));
            throw new IllegalStateException("No launchers found!");
        }
        if (this.updateMode) {
            this.selectLauncher();
            LOGGER.info("Selected launcher {}, going to open updater form", (Object)this.selectedLauncher);
            InstallerGui.openUpdaterForm();
        } else {
            LOGGER.info("Updating preset agent config to use latest subchannel...");
            this.updatedAgentConfigFuture = this.updateMeta.getLatestSubchannel().thenCompose(latestSubchannelName -> {
                Optional<Verifier> verifier = this.presetAgentConfig.subchannelInfo().publicKey().map(Verifier::create);
                LOGGER.info("Latest subchannel is {}, getting info for it...", latestSubchannelName);
                return this.updateMeta.getSubchannelInfo((String)latestSubchannelName, verifier).thenAccept(newSubchannelInfo -> {
                    this.presetAgentConfig = new AgentConfig(this.presetAgentConfig.installName(), this.presetAgentConfig.installDisplayName(), (String)latestSubchannelName, (SubchannelInfo)newSubchannelInfo, this.presetAgentConfig.workingDir());
                    LOGGER.info("Updated preset agent config.");
                });
            });
            this.selectLauncher();
            LOGGER.info("Selected launcher {}, going to open installer form", (Object)this.selectedLauncher);
            InstallerGui.openInstallerForm();
        }
    }

    public void update() {
        InstallerGui.startInstalling();
        this.selectedLauncher.launcherType().handler.install(this.presetAgentConfig, this.selectedLauncher.path(), this).handle(App.installHandler(Lang.get("error.updating.title", new Object[0]), Lang.get("error.updating.message", new Object[0]), InstallerGui::doneUpdate));
    }

    public void install() {
        InstallerGui.startInstalling();
        if (this.updatedAgentConfigFuture != null) {
            LOGGER.info("Waiting for preset agent config update to complete before installing...");
            this.updatedAgentConfigFuture.join();
            LOGGER.info("Preset agent config update complete, let's install!");
        }
        this.selectedLauncher.launcherType().handler.install(this.presetAgentConfig, this.selectedLauncher.path(), this).handle(App.installHandler(Lang.get("error.installing.title", new Object[0]), Lang.get("error.installing.message", new Object[0]), InstallerGui::doneInstall));
    }

    private static BiFunction<Void, Throwable, Object> installHandler(String errorTitle, String errorMessage, Runnable onDone) {
        return ($, ts) -> {
            if (ts != null && ts.getCause() instanceof CancellationException) {
                LOGGER.info("Install cancelled by user", (Throwable)ts);
                System.exit(2);
            } else if (ts != null) {
                CompletionException ce;
                LOGGER.error("Error in install", (Throwable)ts);
                InstallerGui.error(errorTitle, errorMessage + (ts instanceof CompletionException && (ce = (CompletionException)ts).getCause() != null ? ce.getCause().getLocalizedMessage() : ts.getLocalizedMessage()));
                System.exit(1);
            } else {
                LOGGER.info("Install done");
                onDone.run();
                System.exit(0);
            }
            return null;
        };
    }

    private void selectLauncher() {
        if (this.launcherInstalls.size() == 1) {
            LOGGER.info("Automatically selecting install {}", (Object)this.launcherInstalls.getFirst());
            this.selectedLauncher = this.launcherInstalls.getFirst();
        }
        if (this.selectedLauncher == null) {
            LOGGER.info("Asking user for launcher selection");
            InstallerGui.openLauncherSelection();
            if (this.selectedLauncher == null) {
                LOGGER.info("User selected no launcher, closing");
                System.exit(0);
            }
        }
    }

    @Override
    public boolean checkLauncherIsntRunning() {
        if (MojangLauncherHelperWrapper.isMojangLauncherOpen()) {
            LOGGER.warn("Launcher is open, going to ask user if they want to proceed");
            int result = JOptionPane.showConfirmDialog(null, Lang.get("dialog.launcheropen.message", new Object[0]), Lang.get("dialog.launcheropen.title", new Object[0]), 2);
            return result == 0;
        }
        return true;
    }

    @Override
    public AppFramework.Task start(String title) {
        return new TaskImpl(title, new Object[0]).onUpdate(InstallerGui::setProgressBar).onClose(InstallerGui::clearProgress).messageSetter(InstallerGui::setProgressMessage);
    }

    @Override
    public void error(String title, String message, Throwable t) {
        LOGGER.error("{}{}", title, message, t);
    }

    @Override
    public FabricMeta fabricMeta() {
        return this.fabricMeta;
    }

    @Override
    public AgentMeta agentMeta() {
        return this.agentMeta;
    }

    @Override
    public UpdateMeta updateMeta() {
        return this.updateMeta;
    }

    @Override
    public PrismMeta makePrismMeta(Optional<String> metaOverride) {
        return metaOverride.map(o -> new PrismMeta((String)o, (Executor)this.executor)).orElseGet(() -> new PrismMeta(this.executor));
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void close() {
        this.executor.close();
    }

    public static void main(String[] args) throws Exception {
        boolean updateMode;
        LOGGER.info("Hoplite Installer starting");
        List<String> argsList = Arrays.asList(args);
        int launchersArg = argsList.indexOf("--launchers");
        List<Launcher> launchers = null;
        if (launchersArg != -1) {
            int pathIdx = launchersArg + 1;
            if (pathIdx < argsList.size()) {
                launchers = Launcher.parseString(argsList.get(pathIdx));
                LOGGER.info("Going to use provided list of launchers");
            } else {
                LOGGER.warn("--launchers was given but no list of launchers provided");
            }
        }
        AgentConfig agentConfig = null;
        int agentConfigIdx = argsList.indexOf("--agent-config");
        if (agentConfigIdx != -1) {
            int configIdx = agentConfigIdx + 1;
            if (configIdx < argsList.size()) {
                agentConfig = AgentConfig.parseB64(argsList.get(configIdx));
                LOGGER.info("Going to use provided agent config");
            } else {
                LOGGER.warn("--agent-config was given but no agent config provided");
            }
        }
        if (updateMode = argsList.contains("--update")) {
            LOGGER.info("Going to run in updater mode");
        }
        App app = new App(launchers, agentConfig, updateMode);
        app.start();
        app.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        LOGGER.info("All done, see ya.");
    }

    static {
        DEFAULT_AGENT_CONFIG = AgentConfig.parseJson(Json.read(Objects.requireNonNull(App.class.getResource("/default_agent_config.json"))));
    }
}

