/*
 * Decompiled with CFR 0.152.
 */
package gg.hoplite.mcup.agent;

import gg.hoplite.mcup.installer.Launcher;
import gg.hoplite.mcup.installer.LauncherHandler;
import gg.hoplite.mcup.meta.UpdateMeta;
import gg.hoplite.mcup.model.AgentConfig;
import gg.hoplite.mcup.model.SubchannelInfo;
import gg.hoplite.mcup.util.DualOutputStream;
import gg.hoplite.mcup.util.JsonUtil;
import gg.hoplite.mcup.util.SelfJarUtil;
import gg.hoplite.mcup.util.Verifier;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private static final Logger LOGGER = LoggerFactory.getLogger("MCUP Agent");

    public static void premain(String agentArgs) {
        Path log = Path.of("mcup.log", new String[0]);
        try {
            OutputStream logOut = Files.newOutputStream(log, new OpenOption[0]);
            try {
                AgentConfig config;
                System.setOut(new PrintStream(new DualOutputStream(System.out, logOut)));
                System.setErr(new PrintStream(new DualOutputStream(System.err, logOut)));
                try {
                    config = AgentConfig.parseB64(agentArgs);
                }
                catch (JsonUtil.JsonParseException e) {
                    LOGGER.error("Updater could not run. Please re-run the Hoplite installer.", e);
                    LOGGER.error("Updater could not run. Please re-run the Hoplite installer.");
                    System.exit(1);
                    if (logOut != null) {
                        logOut.close();
                    }
                    return;
                }
                LOGGER.info("MCUp Agent starting");
                LOGGER.debug("MCUP config:\n{}", (Object)config);
                try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                    Optional<Verifier> verifier = config.subchannelInfo().publicKey().map(Verifier::create);
                    UpdateMeta updateMeta = new UpdateMeta(config, executor);
                    try {
                        LOGGER.debug("Going to get latest subchannel name");
                        String latestSubchannelName = updateMeta.getLatestSubchannel().join();
                        if (!latestSubchannelName.equals(config.subchannelName())) {
                            LOGGER.info("Latest subchannel ({}) does not match installed ({}), so let's update", (Object)latestSubchannelName, (Object)config.subchannelName());
                            SubchannelInfo newSubchannelInfo = updateMeta.getSubchannelInfo(latestSubchannelName, verifier).join();
                            AgentConfig newAgentConfig = new AgentConfig(config.installName(), config.installDisplayName(), latestSubchannelName, newSubchannelInfo, config.workingDir());
                            List<Launcher> launchers = LauncherHandler.getLaunchersForDirectory(Path.of(System.getProperty("user.dir"), new String[0]));
                            LOGGER.info("Going to run the updater to update from subchannel {} to {}", (Object)config.subchannelName(), (Object)latestSubchannelName);
                            File updaterLog = Path.of("mcup-updater.log", new String[0]).toFile();
                            SelfJarUtil.copyAndRunSelf("mcup-updater.jar", "--launchers", Launcher.toString(launchers), "--agent-config", newAgentConfig.toBase64(), "--update").redirectError(updaterLog).redirectOutput(updaterLog).start();
                            System.exit(0);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Couldn't get latest subchannel, quitting", e);
                        System.exit(0);
                    }
                    LOGGER.info("Going to run unsup");
                    LOGGER.info("=".repeat(40));
                    try {
                        Path selfDir = SelfJarUtil.getThisJarPath().getParent();
                        Path unsupJar = selfDir.resolve("unsup.jar");
                        Process unsupProcess = SelfJarUtil.runJarBuilder(unsupJar, List.of(), "client").directory(config.workingDir().map(x$0 -> Path.of(x$0, new String[0])).orElse(selfDir).toFile()).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
                        int unsupRes = unsupProcess.waitFor();
                        if (unsupRes != 0) {
                            throw new RuntimeException("Failed to run unsup jar, exit code: " + unsupRes);
                        }
                        LOGGER.info("=".repeat(40));
                        LOGGER.info("Successfully run unsup, handing over control to game");
                    }
                    catch (Exception e) {
                        LOGGER.info("=".repeat(40));
                        LOGGER.error("Couldn't run unsup, quitting", e);
                        System.exit(0);
                    }
                }
            }
            finally {
                if (logOut != null) {
                    try {
                        logOut.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Updater could not run. Please re-run the Hoplite installer.", e);
            LOGGER.error("Updater could not run. Please re-run the Hoplite installer.");
            System.exit(2);
        }
    }
}

