/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.text;

import com.github.mizosoft.methanol.internal.Validate;

public interface CharMatcher {
    public boolean matches(char var1);

    default public boolean allMatch(CharSequence s) {
        return s.chars().allMatch((int i) -> this.matches((char)i));
    }

    default public CharMatcher or(CharMatcher other) {
        return c -> this.matches(c) || other.matches(c);
    }

    public static CharMatcher letters() {
        return c -> {
            char lower = Character.toLowerCase(c);
            return lower >= 'a' && lower <= 'z';
        };
    }

    public static CharMatcher digits() {
        return c -> c >= '0' && c <= '9';
    }

    public static CharMatcher lettersOrDigits() {
        return CharMatcher.letters().or(CharMatcher.digits());
    }

    public static CharMatcher anyOf(String chars) {
        return c -> chars.indexOf(c) >= 0;
    }

    public static CharMatcher withinClosedRange(int c1, int c2) {
        Validate.requireArgument((c1 | c2 | c2 - c1) >= 0, "illegal range [%d, %d]", c1, c2);
        return c -> c >= c1 && c <= c2;
    }

    public static CharMatcher is(int c) {
        return x -> c == x;
    }
}

