/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.spi;

import com.github.mizosoft.methanol.BodyDecoder;
import com.github.mizosoft.methanol.internal.annotations.DefaultProvider;
import com.github.mizosoft.methanol.internal.spi.ServiceProviders;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class BodyDecoderFactoryProviders {
    private static final ServiceProviders<BodyDecoder.Factory> factories = new ServiceProviders<BodyDecoder.Factory>(BodyDecoder.Factory.class);
    private static volatile @MonotonicNonNull Map<String, BodyDecoder.Factory> lazyBindings;

    private BodyDecoderFactoryProviders() {
    }

    public static List<BodyDecoder.Factory> factories() {
        return factories.get();
    }

    public static Map<String, BodyDecoder.Factory> bindings() {
        Map<String, BodyDecoder.Factory> bindings = lazyBindings;
        if (bindings == null) {
            lazyBindings = bindings = BodyDecoderFactoryProviders.createBindings();
        }
        return bindings;
    }

    private static Map<String, BodyDecoder.Factory> createBindings() {
        return BodyDecoderFactoryProviders.factories().stream().collect(Collectors.toMap(BodyDecoder.Factory::encoding, Function.identity(), (f1, f2) -> {
            if (f1.getClass().isAnnotationPresent(DefaultProvider.class)) {
                return f2;
            }
            if (f2.getClass().isAnnotationPresent(DefaultProvider.class)) {
                return f1;
            }
            return f2;
        }, LinkedHashMap::new));
    }
}

