/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.flow.Upstream;
import java.util.Objects;
import java.util.concurrent.Flow;

public abstract class ForwardingSubscriber<T>
implements Flow.Subscriber<T> {
    protected final Upstream upstream = new Upstream();

    protected ForwardingSubscriber() {
    }

    protected abstract Flow.Subscriber<? super T> delegate();

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (this.upstream.setOrCancel(subscription)) {
            this.delegate().onSubscribe(subscription);
        }
    }

    @Override
    public void onNext(T item) {
        Objects.requireNonNull(item);
        this.delegate().onNext(item);
    }

    @Override
    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this.upstream.clear();
        this.delegate().onError(throwable);
    }

    @Override
    public void onComplete() {
        this.upstream.clear();
        this.delegate().onComplete();
    }

    public String toString() {
        return Utils.forwardingObjectToString(this, this.delegate());
    }
}

