/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;

public class FlowSupport {
    private static final System.Logger logger = System.getLogger(FlowSupport.class.getName());
    static final String PREFETCH_PROP = "com.github.mizosoft.methanol.flow.prefetch";
    static final String PREFETCH_FACTOR_PROP = "com.github.mizosoft.methanol.flow.prefetchFactor";
    static final int DEFAULT_PREFETCH = 8;
    static final int DEFAULT_PREFETCH_FACTOR = 50;
    private static final int PREFETCH = FlowSupport.loadPrefetch();
    private static final int PREFETCH_THRESHOLD = (int)((float)PREFETCH * ((float)FlowSupport.loadPrefetchFactor() / 100.0f));
    private static final int DROPPED_EXCEPTION_STACK_TRACE_LIMIT = 10;
    public static final Flow.Subscription NOOP_SUBSCRIPTION = new Flow.Subscription(){

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    };
    private static final Flow.Publisher<?> EMPTY_PUBLISHER = subscriber -> {
        Objects.requireNonNull(subscriber);
        try {
            subscriber.onSubscribe(NOOP_SUBSCRIPTION);
        }
        catch (Throwable t) {
            subscriber.onError(t);
            return;
        }
        subscriber.onComplete();
    };
    public static final Executor SYNC_EXECUTOR = SyncExecutor.INSTANCE;

    private FlowSupport() {
    }

    static int loadPrefetch() {
        int prefetch = Integer.getInteger(PREFETCH_PROP, 8);
        return prefetch > 0 ? prefetch : 8;
    }

    static int loadPrefetchFactor() {
        int prefetchFactor = Integer.getInteger(PREFETCH_FACTOR_PROP, 50);
        return prefetchFactor >= 0 && prefetchFactor <= 100 ? prefetchFactor : 50;
    }

    public static IllegalArgumentException illegalRequest() {
        return new IllegalArgumentException("non-positive subscription request");
    }

    public static int prefetch() {
        return PREFETCH;
    }

    public static int prefetchThreshold() {
        return PREFETCH_THRESHOLD;
    }

    public static long getAndAddDemand(Object owner, VarHandle demand, long n) {
        long updatedDemand;
        long currentDemand;
        do {
            if ((updatedDemand = (currentDemand = demand.getVolatile(owner)) + n) >= 0L) continue;
            updatedDemand = Long.MAX_VALUE;
        } while (!demand.compareAndSet(owner, currentDemand, updatedDemand));
        return currentDemand;
    }

    public static long subtractAndGetDemand(Object owner, VarHandle demand, long n) {
        return demand.getAndAdd(owner, -n) - n;
    }

    public static <T> Flow.Publisher<T> emptyPublisher() {
        return EMPTY_PUBLISHER;
    }

    public static void rejectMulticast(Flow.Subscriber<?> subscriber) {
        FlowSupport.reject(subscriber, new IllegalStateException("Multiple subscribers not supported"));
    }

    public static void reject(Flow.Subscriber<?> subscriber, Throwable cause) {
        try {
            subscriber.onSubscribe(NOOP_SUBSCRIPTION);
        }
        catch (Throwable t) {
            cause.addSuppressed(t);
        }
        finally {
            subscriber.onError(cause);
        }
    }

    public static void onDroppedException(Throwable exception) {
        if (logger.isLoggable(System.Logger.Level.WARNING)) {
            logger.log(System.Logger.Level.WARNING, () -> "Dropped exception: " + System.lineSeparator() + "\tat " + StackWalker.getInstance().walk(frames -> frames.limit(10L).map(Object::toString).collect(Collectors.joining(System.lineSeparator() + "\tat "))), exception);
        }
    }

    private static enum SyncExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return SyncExecutor.class.getSimpleName();
        }
    }
}

