/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import com.github.mizosoft.methanol.internal.flow.AbstractSubscription;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractPollableSubscription<T>
extends AbstractSubscription<T> {
    protected AbstractPollableSubscription(Flow.Subscriber<? super T> downstream, Executor executor) {
        super(downstream, executor);
    }

    protected abstract @Nullable T poll();

    protected abstract boolean isComplete();

    @Override
    protected long emit(Flow.Subscriber<? super T> downstream, long emit) {
        long submitted = 0L;
        while (true) {
            T next;
            if (this.isComplete()) {
                this.cancelOnComplete(downstream);
                return submitted;
            }
            if (submitted >= emit || (next = this.poll()) == null) {
                return submitted;
            }
            if (!this.submitOnNext(downstream, next)) break;
            ++submitted;
        }
        return 0L;
    }
}

