/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.extensions;

import com.github.mizosoft.methanol.HttpReadTimeoutException;
import com.github.mizosoft.methanol.internal.concurrent.Delayer;
import com.github.mizosoft.methanol.internal.flow.TimeoutSubscriber;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionStage;

public final class TimeoutBodySubscriber<T>
extends TimeoutSubscriber<List<ByteBuffer>, HttpResponse.BodySubscriber<T>>
implements HttpResponse.BodySubscriber<T> {
    public TimeoutBodySubscriber(HttpResponse.BodySubscriber<T> downstream, Duration timeout, Delayer delayer) {
        super(downstream, timeout, delayer);
    }

    @Override
    protected Throwable timeoutError(long index, Duration timeout) {
        return new HttpReadTimeoutException(String.format("read [%d] timed out after %d ms", index, timeout.toMillis()));
    }

    @Override
    public CompletionStage<T> getBody() {
        return ((HttpResponse.BodySubscriber)this.delegate()).getBody();
    }
}

