/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.extensions;

import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.util.Objects;

public final class ImmutableResponseInfo
implements HttpResponse.ResponseInfo {
    private final int statusCode;
    private final HttpHeaders headers;
    private final HttpClient.Version version;

    public ImmutableResponseInfo(int statusCode, HttpHeaders headers, HttpClient.Version version) {
        this.statusCode = statusCode;
        this.headers = Objects.requireNonNull(headers);
        this.version = Objects.requireNonNull(version);
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public HttpClient.Version version() {
        return this.version;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[statusCode=" + this.statusCode + ", headers=" + String.valueOf(this.headers) + ", version=" + String.valueOf((Object)this.version) + "]";
    }

    public static HttpResponse.ResponseInfo from(HttpResponse<?> response) {
        return new ImmutableResponseInfo(response.statusCode(), response.headers(), response.version());
    }
}

