/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.extensions;

import com.github.mizosoft.methanol.Methanol;
import com.github.mizosoft.methanol.ResponseBuilder;
import com.github.mizosoft.methanol.internal.extensions.ImmutableResponseInfo;
import com.github.mizosoft.methanol.internal.extensions.PublisherBodySubscriber;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class Handlers {
    private static final System.Logger logger = System.getLogger(Handlers.class.getName());

    private Handlers() {
    }

    public static <T> CompletableFuture<HttpResponse<T>> handleAsync(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response, HttpResponse.BodyHandler<T> handler, Executor executor) {
        return Handlers.handleAsync(response, response.body(), handler, executor);
    }

    public static <T> CompletableFuture<HttpResponse<T>> handleAsync(HttpResponse<?> response, Flow.Publisher<List<ByteBuffer>> publisher, HttpResponse.BodyHandler<T> handler, Executor executor) {
        return Handlers.handleAsync(ImmutableResponseInfo.from(response), publisher, handler, executor).thenApply(body -> ResponseBuilder.from(response).body(body).build());
    }

    public static <T> CompletableFuture<T> handleAsync(HttpResponse.ResponseInfo responseInfo, Flow.Publisher<List<ByteBuffer>> publisher, HttpResponse.BodyHandler<T> handler, Executor executor) {
        HttpResponse.BodySubscriber subscriber = handler.apply(responseInfo);
        CompletableFuture.runAsync(() -> publisher.subscribe(subscriber), executor).whenComplete((__, ex) -> {
            if (ex != null) {
                logger.log(System.Logger.Level.WARNING, "Exception thrown by publisher::subscribe", (Throwable)ex);
            }
        });
        return CompletableFuture.supplyAsync(subscriber::getBody, executor).thenCompose(Function.identity());
    }

    public static <T> Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> toPublisherChain(Methanol.Interceptor.Chain<T> chain, Executor executor) {
        HttpResponse.PushPromiseHandler relayingPushPromiseHandler = chain.pushPromiseHandler().map(pushHandler -> Handlers.toRelayingPushPromiseHandler(pushHandler, executor)).orElse(null);
        return chain.with(PublisherBodySubscriber.bodyHandler(), relayingPushPromiseHandler);
    }

    private static <T> HttpResponse.PushPromiseHandler<Flow.Publisher<List<ByteBuffer>>> toRelayingPushPromiseHandler(HttpResponse.PushPromiseHandler<T> downstreamPushPromiseHandler, Executor executor) {
        return (initiatingRequest, pushPromiseRequest, acceptor) -> {
            Function downstreamAcceptor = bodyHandler -> ((CompletableFuture)acceptor.apply(PublisherBodySubscriber.bodyHandler())).thenCompose(response -> Handlers.handleAsync(response, bodyHandler, executor));
            downstreamPushPromiseHandler.applyPushPromise(initiatingRequest, pushPromiseRequest, downstreamAcceptor);
        };
    }
}

