/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.extensions;

import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.flow.AbstractPollableSubscription;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ByteBufferBodyPublisher
implements HttpRequest.BodyPublisher {
    private final ByteBuffer buffer;
    private final int contentLength;
    private final int downstreamBufferSize;

    public ByteBufferBodyPublisher(ByteBuffer buffer) {
        this(buffer, Utils.BUFFER_SIZE);
    }

    public ByteBufferBodyPublisher(ByteBuffer buffer, int downstreamBufferSize) {
        this.buffer = buffer.duplicate();
        this.contentLength = this.buffer.remaining();
        Validate.requireArgument(downstreamBufferSize > 0, "Non-positive buffer size: %d", downstreamBufferSize);
        this.downstreamBufferSize = downstreamBufferSize;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        new ByteBufferSubscription(subscriber, this.buffer.duplicate(), this.downstreamBufferSize).fireOrKeepAlive();
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    private static final class ByteBufferSubscription
    extends AbstractPollableSubscription<ByteBuffer> {
        private final ByteBuffer buffer;
        private final int bufferSize;

        ByteBufferSubscription(Flow.Subscriber<? super ByteBuffer> downstream, ByteBuffer buffer, int bufferSize) {
            super(downstream, FlowSupport.SYNC_EXECUTOR);
            this.buffer = buffer;
            this.bufferSize = bufferSize;
        }

        @Override
        protected @Nullable ByteBuffer poll() {
            if (!this.buffer.hasRemaining()) {
                return null;
            }
            int length = Math.min(this.bufferSize, this.buffer.remaining());
            int originalLimit = this.buffer.limit();
            int newPosition = this.buffer.position() + length;
            ByteBuffer next = this.buffer.limit(newPosition).slice();
            this.buffer.limit(originalLimit).position(newPosition);
            return next.asReadOnlyBuffer();
        }

        @Override
        protected boolean isComplete() {
            return !this.buffer.hasRemaining();
        }
    }
}

