/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.decoder;

import com.github.mizosoft.methanol.decoder.AsyncDecoder;
import com.github.mizosoft.methanol.internal.decoder.InflaterUtils;
import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.zip.Inflater;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class DeflateDecoder
implements AsyncDecoder {
    static final String ENCODING = "deflate";
    private static final int CM_MASK = 3840;
    private static final int SHIFTED_CM_DEFLATE = 2048;
    private static final Object CLOSED = new Object();
    private static final VarHandle INFLATER_REFERENCE;
    private @MonotonicNonNull Object inflaterReference;

    DeflateDecoder() {
    }

    @Override
    public String encoding() {
        return ENCODING;
    }

    @Override
    public void decode(AsyncDecoder.ByteSource source, AsyncDecoder.ByteSink sink) throws IOException {
        Inflater inflater;
        Object inflaterPlaceholder = this.inflaterReference;
        if (inflaterPlaceholder == CLOSED) {
            return;
        }
        if (inflaterPlaceholder != null) {
            inflater = (Inflater)inflaterPlaceholder;
        } else if (source.remaining() >= 2L) {
            ByteBuffer header = ByteBuffer.allocate(2);
            source.pullBytes(header);
            header.flip();
            boolean nowrap = !DeflateDecoder.isProbablyZLibHeader(header.getShort());
            inflater = new Inflater(nowrap);
            if (!INFLATER_REFERENCE.compareAndSet(this, null, inflater)) {
                inflater.end();
                return;
            }
            inflater.setInput(header.rewind());
        } else {
            if (source.finalSource()) {
                throw new EOFException("Unexpected end of deflate stream");
            }
            return;
        }
        InflaterUtils.inflateSource(inflater, source, sink);
        if (inflater.finished()) {
            if (source.hasRemaining()) {
                throw new IOException("Deflate stream finished prematurely");
            }
        } else if (source.finalSource()) {
            assert (!source.hasRemaining());
            throw new EOFException("Unexpected end of deflate stream");
        }
    }

    @Override
    public void close() {
        Object inflater = INFLATER_REFERENCE.getAndSet(this, CLOSED);
        if (inflater instanceof Inflater) {
            ((Inflater)inflater).end();
        }
    }

    private static boolean isProbablyZLibHeader(short header) {
        return (header & 0xF00) == 2048 && header % 31 == 0;
    }

    static {
        try {
            INFLATER_REFERENCE = MethodHandles.lookup().findVarHandle(DeflateDecoder.class, "inflaterReference", Object.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

