/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.concurrent;

import com.github.mizosoft.methanol.internal.concurrent.Lazy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedExecutors {
    private static final AtomicInteger nextThreadId = new AtomicInteger();
    private static final ThreadFactory threadFactory = r -> {
        Thread thread = new Thread(r);
        thread.setName("methanol-thread-" + nextThreadId.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    };
    private static final Lazy<ExecutorService> lazyExecutor = Lazy.of(() -> Executors.newCachedThreadPool(threadFactory));
    private static final Lazy<ScheduledExecutorService> lazyScheduler = Lazy.of(() -> Executors.newScheduledThreadPool(1, threadFactory));

    private SharedExecutors() {
    }

    public static ExecutorService executor() {
        return lazyExecutor.get();
    }

    public static ScheduledExecutorService scheduler() {
        return lazyScheduler.get();
    }
}

