/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.concurrent;

import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.concurrent.Delayer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class ScheduledExecutorServiceDelayer
implements Delayer {
    private final ScheduledExecutorService scheduler;

    ScheduledExecutorServiceDelayer(ScheduledExecutorService scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler);
    }

    @Override
    public Future<Void> delay(Runnable task, Duration delay, Executor executor) {
        if (delay.isZero()) {
            return CompletableFuture.runAsync(task, executor);
        }
        CompletableFuture<Void> taskCompletionFuture = new CompletableFuture<Void>();
        ScheduledFuture<?> taskSubmissionFuture = this.scheduler.schedule(() -> taskCompletionFuture.completeAsync(() -> {
            task.run();
            return null;
        }, executor), TimeUnit.NANOSECONDS.convert(delay), TimeUnit.NANOSECONDS);
        taskCompletionFuture.whenComplete((__, e) -> {
            if (e instanceof CancellationException) {
                taskSubmissionFuture.cancel(false);
            }
        });
        return taskCompletionFuture;
    }

    public String toString() {
        return Utils.toStringIdentityPrefix(this) + "[scheduler=" + String.valueOf(this.scheduler) + "]";
    }
}

