/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.ResponseBuilder;
import com.github.mizosoft.methanol.TrackedResponse;
import com.github.mizosoft.methanol.internal.cache.RawResponse;
import com.github.mizosoft.methanol.internal.extensions.Handlers;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;

abstract class PublisherResponse
extends RawResponse {
    final Flow.Publisher<List<ByteBuffer>> publisher;

    PublisherResponse(TrackedResponse<?> response, Flow.Publisher<List<ByteBuffer>> publisher) {
        super(PublisherResponse.dropBody(response));
        this.publisher = Objects.requireNonNull(publisher);
    }

    @Override
    public <T> CompletableFuture<TrackedResponse<T>> handleAsync(HttpResponse.BodyHandler<T> handler, Executor executor) {
        return Handlers.handleAsync(this.response, this.publisher, handler, executor).thenApply(response -> (TrackedResponse)response);
    }

    private static TrackedResponse<?> dropBody(TrackedResponse<?> response) {
        return response.body() != null ? ResponseBuilder.from(response).dropBody().buildTrackedResponse() : response;
    }
}

