/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.internal.Utils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileIO {
    private FileIO() {
    }

    static ByteBuffer read(FileChannel channel, int byteCount) throws IOException {
        return FileIO.read(channel, byteCount, -1L);
    }

    static ByteBuffer read(FileChannel channel, int byteCount, long position) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(byteCount);
        int read = FileIO.read(channel, buffer, position);
        if (buffer.hasRemaining()) {
            throw new EOFException(String.format("Expected %d bytes, found %d", byteCount, read));
        }
        return buffer.flip();
    }

    @CanIgnoreReturnValue
    static int read(FileChannel channel, ByteBuffer dst) throws IOException {
        int read;
        int totalRead = 0;
        while (dst.hasRemaining() && (read = channel.read(dst)) >= 0) {
            totalRead += read;
        }
        return totalRead;
    }

    @CanIgnoreReturnValue
    static int read(FileChannel channel, ByteBuffer dst, long position) throws IOException {
        int read;
        int totalRead = 0;
        while (dst.hasRemaining() && (read = position >= 0L ? channel.read(dst, position) : channel.read(dst)) >= 0) {
            totalRead += read;
            if (position < 0L) continue;
            position += (long)read;
        }
        return totalRead;
    }

    @CanIgnoreReturnValue
    static long read(FileChannel channel, ByteBuffer[] dsts) throws IOException {
        long totalRead;
        long read;
        long readable = Utils.remaining(dsts);
        for (totalRead = 0L; totalRead < readable && (read = channel.read(dsts)) >= 0L; totalRead += read) {
        }
        return totalRead;
    }

    @CanIgnoreReturnValue
    static int write(FileChannel channel, ByteBuffer src) throws IOException {
        return FileIO.write(channel, src, -1L);
    }

    @CanIgnoreReturnValue
    static int write(FileChannel channel, ByteBuffer src, long position) throws IOException {
        int totalWritten = 0;
        while (src.hasRemaining()) {
            int written = position >= 0L ? channel.write(src, position) : channel.write(src);
            totalWritten += written;
            if (position < 0L) continue;
            position += (long)written;
        }
        return totalWritten;
    }

    @CanIgnoreReturnValue
    static long write(FileChannel channel, ByteBuffer[] srcs) throws IOException {
        long totalWritten;
        long written;
        long writable = Utils.remaining(srcs);
        for (totalWritten = 0L; totalWritten < writable; totalWritten += written) {
            written = channel.write(srcs);
        }
        return totalWritten;
    }
}

