/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.ResponseBuilder;
import com.github.mizosoft.methanol.TrackedResponse;
import com.github.mizosoft.methanol.internal.cache.CacheReadingPublisher;
import com.github.mizosoft.methanol.internal.cache.PublisherResponse;
import com.github.mizosoft.methanol.internal.cache.Store;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Consumer;

public final class CacheResponse
extends PublisherResponse
implements Closeable {
    private final Store.Viewer viewer;
    private final Executor executor;

    public CacheResponse(TrackedResponse<?> response, Store.Viewer viewer, Executor executor, CacheReadingPublisher.Listener readListener) {
        this(response, new CacheReadingPublisher(viewer, executor, readListener), viewer, executor);
    }

    private CacheResponse(TrackedResponse<?> response, Flow.Publisher<List<ByteBuffer>> body, Store.Viewer viewer, Executor executor) {
        super(response, body);
        this.viewer = Objects.requireNonNull(viewer);
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public CacheResponse with(Consumer<ResponseBuilder<?>> mutator) {
        return new CacheResponse(ResponseBuilder.from(this.response).apply(mutator).buildTrackedResponse(), this.publisher, this.viewer, this.executor);
    }

    @Override
    public void close() {
        this.viewer.close();
    }

    public CompletableFuture<Optional<Store.Editor>> edit() {
        return this.viewer.edit(this.executor);
    }
}

