/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.adapter;

import com.github.mizosoft.methanol.BodyAdapter;
import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MoreBodyPublishers;
import com.github.mizosoft.methanol.MoreBodySubscribers;
import com.github.mizosoft.methanol.TypeRef;
import com.github.mizosoft.methanol.internal.Utils;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBodyAdapter
implements BodyAdapter {
    private final Set<MediaType> compatibleMediaTypes;

    protected AbstractBodyAdapter(MediaType ... compatibleMediaTypes) {
        this.compatibleMediaTypes = Set.of(compatibleMediaTypes);
    }

    @Override
    public final boolean isCompatibleWith(MediaType mediaType) {
        return this.compatibleMediaTypes.stream().anyMatch(mediaType::isCompatibleWith);
    }

    protected Set<MediaType> compatibleMediaTypes() {
        return this.compatibleMediaTypes;
    }

    protected void requireSupport(TypeRef<?> typeRef) {
        this.requireSupport(typeRef, BodyAdapter.Hints.empty());
    }

    protected void requireSupport(Class<?> type) {
        this.requireSupport(TypeRef.of(type), BodyAdapter.Hints.empty());
    }

    protected void requireSupport(TypeRef<?> typeRef, BodyAdapter.Hints hints) {
        if (!this.supportsType(typeRef)) {
            throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(typeRef));
        }
        if (!this.isCompatibleWith(hints.mediaTypeOrAny())) {
            throw new UnsupportedOperationException("This adapter is not compatible with: " + String.valueOf(hints.mediaTypeOrAny()));
        }
    }

    protected void requireCompatibleOrNull(@Nullable MediaType mediaType) {
        if (mediaType != null && !this.isCompatibleWith(mediaType)) {
            throw new UnsupportedOperationException("Adapter not compatible with: " + String.valueOf(mediaType));
        }
    }

    public static Charset charsetOrDefault(@Nullable MediaType mediaType, Charset defaultCharset) {
        Objects.requireNonNull(defaultCharset);
        return mediaType != null ? mediaType.charsetOrDefault(defaultCharset) : defaultCharset;
    }

    public static Charset charsetOrUtf8(@Nullable MediaType mediaType) {
        return AbstractBodyAdapter.charsetOrDefault(mediaType, StandardCharsets.UTF_8);
    }

    public static HttpRequest.BodyPublisher attachMediaType(HttpRequest.BodyPublisher publisher, @Nullable MediaType mediaType) {
        Objects.requireNonNull(publisher);
        if (mediaType != null && !mediaType.hasWildcard()) {
            return MoreBodyPublishers.ofMediaType(publisher, mediaType);
        }
        return publisher;
    }

    public static interface BaseDecoder
    extends BodyAdapter.Decoder {
        @Override
        default public <T> HttpResponse.BodySubscriber<T> toObject(TypeRef<T> typeRef, @Nullable MediaType mediaType) {
            return this.toObject(typeRef, Utils.hintsOf(mediaType));
        }

        @Override
        public <T> HttpResponse.BodySubscriber<T> toObject(TypeRef<T> var1, BodyAdapter.Hints var2);

        @Override
        default public <T> HttpResponse.BodySubscriber<Supplier<T>> toDeferredObject(TypeRef<T> typeRef, @Nullable MediaType mediaType) {
            return this.toDeferredObject(typeRef, Utils.hintsOf(mediaType));
        }

        @Override
        default public <T> HttpResponse.BodySubscriber<Supplier<T>> toDeferredObject(TypeRef<T> typeRef, BodyAdapter.Hints hints) {
            return MoreBodySubscribers.fromAsyncSubscriber(this.toObject(typeRef, hints), subscriber -> CompletableFuture.completedStage(() -> subscriber.getBody().toCompletableFuture().join()));
        }
    }

    public static interface BaseEncoder
    extends BodyAdapter.Encoder {
        @Override
        default public HttpRequest.BodyPublisher toBody(Object value, @Nullable MediaType mediaType) {
            return this.toBody(value, TypeRef.ofRuntimeType(value), Utils.hintsOf(mediaType));
        }

        @Override
        public <T> HttpRequest.BodyPublisher toBody(T var1, TypeRef<T> var2, BodyAdapter.Hints var3);
    }
}

