/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.cache.DiskStore;
import com.github.mizosoft.methanol.internal.cache.MemoryStore;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;

public interface StorageExtension {
    public static StorageExtension inMemory(long maxSize) {
        Validate.requireArgument(maxSize > 0L, "Non-positive maxSize: %d", maxSize);
        return (executor, appVersion) -> new MemoryStore(maxSize);
    }

    public static StorageExtension onDisk(Path directory, long maxSize) {
        Objects.requireNonNull(directory);
        Validate.requireArgument(maxSize > 0L, "Non-positive maxSize: %d", maxSize);
        return (executor, appVersion) -> {
            try {
                return DiskStore.newBuilder().directory(directory).maxSize(maxSize).executor(executor).appVersion(appVersion).build();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }
}

