/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MimeBodyPublisher;
import com.github.mizosoft.methanol.MoreBodyPublishers;
import com.github.mizosoft.methanol.MultipartBodyPublisher;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.extensions.ForwardingBodyPublisher;
import com.github.mizosoft.methanol.internal.flow.AbstractQueueSubscription;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import com.github.mizosoft.methanol.internal.flow.ForwardingSubscriber;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ProgressTracker {
    private final Options options;
    private final boolean userVisibleExecutor;

    private ProgressTracker(Builder builder) {
        Executor executor;
        Executor configuredExecutor = builder.executor;
        if (configuredExecutor != null) {
            executor = configuredExecutor;
            this.userVisibleExecutor = true;
        } else {
            executor = FlowSupport.SYNC_EXECUTOR;
            this.userVisibleExecutor = false;
        }
        this.options = new Options(builder.bytesTransferredThreshold, builder.timePassedThreshold, executor, builder.enclosedProgress, builder.clock);
    }

    public long bytesTransferredThreshold() {
        return this.options.bytesTransferredThreshold;
    }

    public Optional<Duration> timePassedThreshold() {
        return Optional.ofNullable(this.options.timePassedThreshold);
    }

    public boolean enclosedProgress() {
        return this.options.enclosedProgress;
    }

    public Optional<Executor> executor() {
        return this.userVisibleExecutor ? Optional.of(this.options.executor) : Optional.empty();
    }

    public HttpRequest.BodyPublisher tracking(HttpRequest.BodyPublisher upstream, Listener listener) {
        TrackingBodyPublisher trackingPublisher = new TrackingBodyPublisher(upstream, listener, this.options);
        return upstream instanceof MimeBodyPublisher ? MoreBodyPublishers.ofMediaType(trackingPublisher, ((MimeBodyPublisher)upstream).mediaType()) : trackingPublisher;
    }

    public MimeBodyPublisher trackingMultipart(MultipartBodyPublisher upstream, MultipartListener listener) {
        return new MultipartTrackingBodyPublisher(upstream, listener, this.options);
    }

    public <T> HttpResponse.BodySubscriber<T> tracking(HttpResponse.BodySubscriber<T> downstream, Listener listener, long contentLengthIfKnown) {
        return new TrackingBodySubscriber<T>(downstream, listener, this.options, contentLengthIfKnown);
    }

    public <T> HttpResponse.BodyHandler<T> tracking(HttpResponse.BodyHandler<T> handler, Listener listener) {
        Objects.requireNonNull(handler);
        Objects.requireNonNull(listener);
        return responseInfo -> this.tracking(handler.apply(responseInfo), listener, responseInfo.headers().firstValueAsLong("Content-Length").orElse(-1L));
    }

    public String toString() {
        return Utils.toStringIdentityPrefix(this) + "[bytesTransferredThreshold=" + this.bytesTransferredThreshold() + ", timePassedThreshold=" + String.valueOf(this.timePassedThreshold()) + ", enclosedProgress=" + this.enclosedProgress() + "]";
    }

    public static ProgressTracker create() {
        return ProgressTracker.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static final class MultipartTrackingBodyPublisher
    extends ForwardingBodyPublisher
    implements MimeBodyPublisher {
        private final MultipartListener listener;
        private final Options options;
        private final List<MultipartBodyPublisher.Part> parts;
        private final MediaType mediaType;

        MultipartTrackingBodyPublisher(MultipartBodyPublisher upstream, MultipartListener listener, Options options) {
            super(upstream);
            this.listener = Objects.requireNonNull(listener);
            this.options = Objects.requireNonNull(options);
            this.parts = upstream.parts();
            this.mediaType = upstream.mediaType();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            Objects.requireNonNull(subscriber);
            this.delegate().subscribe(new MultipartTrackingSubscriber(subscriber, this.listener, this.options, this.contentLength(), this.parts.get(0)));
        }

        @Override
        public MediaType mediaType() {
            return this.mediaType;
        }

        private static final class MultipartTrackingSubscriber
        extends AbstractTrackingSubscriber<ByteBuffer, MultipartProgress, MultipartProgression>
        implements MultipartBodyPublisher.PartSequenceListener {
            private MultipartBodyPublisher.Part currentPart;
            private boolean partUpdatePending;
            private boolean partSequenceCompleted;

            MultipartTrackingSubscriber(Flow.Subscriber<? super ByteBuffer> downstream, MultipartListener listener, Options options, long contentLength, MultipartBodyPublisher.Part firstPart) {
                super(downstream, listener, options, new MultipartProgression(options.bytesTransferredThreshold, options.timePassedThreshold, contentLength, firstPart));
                this.currentPart = firstPart;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                MultipartBodyPublisher.PartSequenceListener.register(subscription, this);
                super.onSubscribe(subscription);
            }

            @Override
            long countBytes(ByteBuffer buffer) {
                return buffer.remaining();
            }

            @Override
            synchronized void updateProgression(MultipartProgression progression, Instant updateTime, long byteCount) {
                if (this.partUpdatePending) {
                    this.partUpdatePending = false;
                    progression.updatePart(this.currentPart, updateTime);
                } else if (!this.partSequenceCompleted) {
                    progression.updatePartProgress(updateTime, byteCount);
                }
                progression.update(updateTime, byteCount);
            }

            @Override
            public synchronized void onNextPart(MultipartBodyPublisher.Part part) {
                this.currentPart = part;
                this.partUpdatePending = true;
            }

            @Override
            public synchronized void onSequenceCompletion() {
                this.partSequenceCompleted = true;
            }
        }
    }

    private static final class TrackingBodyPublisher
    extends ForwardingBodyPublisher {
        private final Listener listener;
        private final Options options;

        TrackingBodyPublisher(HttpRequest.BodyPublisher upstream, Listener listener, Options options) {
            super(upstream);
            this.listener = Objects.requireNonNull(listener);
            this.options = Objects.requireNonNull(options);
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            Objects.requireNonNull(subscriber);
            this.delegate().subscribe(new TrackingSubscriber(subscriber, this.listener, this.options, this.contentLength()));
        }

        private static final class TrackingSubscriber
        extends AbstractTrackingSubscriber<ByteBuffer, Progress, UnipartProgression> {
            TrackingSubscriber(Flow.Subscriber<? super ByteBuffer> downstream, Listener listener, Options options, long contentLength) {
                super(downstream, listener, options, new UnipartProgression(options.bytesTransferredThreshold, options.timePassedThreshold, contentLength));
            }

            @Override
            long countBytes(ByteBuffer buffer) {
                return buffer.remaining();
            }
        }
    }

    private static final class TrackingBodySubscriber<T>
    extends AbstractTrackingSubscriber<List<ByteBuffer>, Progress, UnipartProgression>
    implements HttpResponse.BodySubscriber<T> {
        private final Supplier<CompletionStage<T>> bodySupplier = downstream::getBody;

        TrackingBodySubscriber(HttpResponse.BodySubscriber<T> downstream, BaseListener<Progress> listener, Options options, long contentLength) {
            super(downstream, listener, options, new UnipartProgression(options.bytesTransferredThreshold, options.timePassedThreshold, contentLength));
        }

        @Override
        long countBytes(List<ByteBuffer> buffers) {
            return buffers.stream().mapToLong(Buffer::remaining).sum();
        }

        @Override
        public CompletionStage<T> getBody() {
            return this.bodySupplier.get();
        }
    }

    private static abstract class AbstractTrackingSubscriber<B, P extends Progress, R extends Progression<P>>
    extends ForwardingSubscriber<B> {
        private final Flow.Subscriber<? super B> downstream;
        private final ProgressSubscription listenerSubscription;

        AbstractTrackingSubscriber(Flow.Subscriber<? super B> downstream, BaseListener<P> listener, Options options, R progression) {
            this.downstream = downstream;
            this.listenerSubscription = new ProgressSubscription(this, listener, options, progression);
        }

        abstract long countBytes(B var1);

        void updateProgression(R progression, Instant updateTime, long byteCount) {
            ((Progression)progression).update(updateTime, byteCount);
        }

        @Override
        protected Flow.Subscriber<? super B> delegate() {
            return this.downstream;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription);
            if (this.upstream.setOrCancel(subscription)) {
                try {
                    this.listenerSubscription.onSubscribe();
                }
                finally {
                    this.delegate().onSubscribe(subscription);
                }
            }
        }

        @Override
        public void onNext(B item) {
            this.listenerSubscription.onNext(this.countBytes(item));
            super.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            try {
                this.listenerSubscription.onError(throwable);
            }
            finally {
                super.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            try {
                this.listenerSubscription.onComplete();
            }
            finally {
                super.onComplete();
            }
        }

        private static final class ProgressSubscription
        extends AbstractQueueSubscription<P> {
            private final Options options;
            private final R progression;
            private boolean signaledLastProgress;
            final /* synthetic */ AbstractTrackingSubscriber this$0;

            ProgressSubscription(BaseListener<P> listener, Options options, R progression) {
                this.this$0 = var1_1;
                super(listener, options.executor);
                this.options = options;
                this.progression = progression;
            }

            void onSubscribe() {
                ((Progression)this.progression).start(this.options.clock.instant());
                if (this.options.enclosedProgress) {
                    this.submitSilently(((Progression)this.progression).snapshot(false));
                }
                this.fireOrKeepAlive();
            }

            void onNext(long byteCount) {
                this.this$0.updateProgression(this.progression, this.options.clock.instant(), byteCount);
                if (((Progression)this.progression).hasPendingProgress()) {
                    Object progress = ((Progression)this.progression).snapshot(false);
                    this.signaledLastProgress = progress.done();
                    ((Progression)this.progression).rewind();
                    this.submit(progress);
                }
            }

            void onError(Throwable error) {
                this.fireOrKeepAliveOnError(error);
            }

            void onComplete() {
                if (this.options.enclosedProgress && !this.signaledLastProgress) {
                    this.this$0.updateProgression(this.progression, this.options.clock.instant(), 0L);
                    this.submitAndComplete(((Progression)this.progression).snapshot(true));
                } else {
                    this.complete();
                }
            }
        }
    }

    private static final class MultipartProgression
    extends Progression<MultipartProgress> {
        private MultipartBodyPublisher.Part currentPart;
        private UnipartProgression partProgression;
        private boolean partChangePending;

        MultipartProgression(long bytesTransferredThreshold, @Nullable Duration timePassedThreshold, long contentLength, MultipartBodyPublisher.Part firstPart) {
            super(bytesTransferredThreshold, timePassedThreshold, contentLength);
            this.currentPart = firstPart;
            this.partProgression = new UnipartProgression(0L, Duration.ZERO, firstPart.bodyPublisher().contentLength());
            this.partChangePending = true;
        }

        @Override
        void rewind() {
            super.rewind();
            this.partProgression.rewind();
        }

        void updatePart(MultipartBodyPublisher.Part part, Instant progressionStartTime) {
            this.currentPart = part;
            this.partProgression = new UnipartProgression(0L, Duration.ZERO, part.bodyPublisher().contentLength());
            this.partProgression.start(progressionStartTime);
            this.partChangePending = true;
        }

        void updatePartProgress(Instant updateTime, long partByteCount) {
            this.partProgression.update(updateTime, partByteCount);
        }

        @Override
        MultipartProgress snapshot(boolean completed) {
            boolean partChanged = this.partChangePending;
            this.partChangePending = false;
            return new MultipartProgressSnapshot(this.bytesTransferred, this.totalBytesTransferred, Duration.between(this.lastUpdateTime, this.updateTime), Duration.between(this.startTime, this.updateTime), this.contentLength, completed, this.currentPart, this.partProgression.snapshot(false), partChanged);
        }
    }

    private static final class UnipartProgression
    extends Progression<Progress> {
        UnipartProgression(long bytesTransferredThreshold, @Nullable Duration timePassedThreshold, long contentLength) {
            super(bytesTransferredThreshold, timePassedThreshold, contentLength);
        }

        @Override
        Progress snapshot(boolean completed) {
            return new ProgressSnapshot(this.bytesTransferred, this.totalBytesTransferred, Duration.between(this.lastUpdateTime, this.updateTime), Duration.between(this.startTime, this.updateTime), this.contentLength, completed);
        }
    }

    private static abstract class Progression<P extends Progress> {
        private final long bytesTransferredThreshold;
        private final Duration timePassedThreshold;
        final long contentLength;
        long bytesTransferred;
        long totalBytesTransferred;
        Instant startTime = Instant.MIN;
        Instant lastUpdateTime = Instant.MIN;
        Instant updateTime = Instant.MIN;

        Progression(long bytesTransferredThreshold, @Nullable Duration timePassedThreshold, long contentLength) {
            this.bytesTransferredThreshold = bytesTransferredThreshold;
            this.timePassedThreshold = Objects.requireNonNullElse(timePassedThreshold, Duration.ZERO);
            this.contentLength = contentLength;
        }

        void start(Instant startTime) {
            this.startTime = startTime;
            this.lastUpdateTime = startTime;
            this.updateTime = startTime;
        }

        void update(Instant updateTime, long byteCount) {
            this.updateTime = updateTime;
            this.bytesTransferred += byteCount;
            this.totalBytesTransferred += byteCount;
        }

        boolean hasPendingProgress() {
            return this.bytesTransferred >= this.bytesTransferredThreshold && Duration.between(this.lastUpdateTime, this.updateTime).compareTo(this.timePassedThreshold) >= 0;
        }

        void rewind() {
            this.bytesTransferred = 0L;
            this.lastUpdateTime = this.updateTime;
        }

        abstract P snapshot(boolean var1);
    }

    private static final class MultipartProgressSnapshot
    extends ProgressSnapshot
    implements MultipartProgress {
        private final MultipartBodyPublisher.Part part;
        private final Progress partProgress;
        private final boolean partChanged;

        MultipartProgressSnapshot(long bytesTransferred, long totalBytesTransferred, Duration timePassed, Duration totalTimePassed, long contentLength, boolean lastProgress, MultipartBodyPublisher.Part part, Progress partProgress, boolean partChanged) {
            super(bytesTransferred, totalBytesTransferred, timePassed, totalTimePassed, contentLength, lastProgress);
            this.part = part;
            this.partProgress = partProgress;
            this.partChanged = partChanged;
        }

        @Override
        public MultipartBodyPublisher.Part part() {
            return this.part;
        }

        @Override
        public Progress partProgress() {
            return this.partProgress;
        }

        @Override
        public boolean partChanged() {
            return this.partChanged;
        }
    }

    static class ProgressSnapshot
    implements Progress {
        private final long bytesTransferred;
        private final long totalBytesTransferred;
        private final long contentLength;
        private final Duration timePassed;
        private final Duration totalTimePassed;
        private final boolean lastProgress;

        ProgressSnapshot(long bytesTransferred, long totalBytesTransferred, Duration timePassed, Duration totalTimePassed, long contentLength, boolean lastProgress) {
            this.bytesTransferred = bytesTransferred;
            this.totalBytesTransferred = totalBytesTransferred;
            this.contentLength = contentLength;
            this.timePassed = timePassed;
            this.totalTimePassed = totalTimePassed;
            this.lastProgress = lastProgress;
        }

        @Override
        public long bytesTransferred() {
            return this.bytesTransferred;
        }

        @Override
        public long totalBytesTransferred() {
            return this.totalBytesTransferred;
        }

        @Override
        public Duration timePassed() {
            return this.timePassed;
        }

        @Override
        public Duration totalTimePassed() {
            return this.totalTimePassed;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public boolean done() {
            return this.lastProgress || this.determinate() && this.totalBytesTransferred >= this.contentLength;
        }

        @Override
        public String toString() {
            return String.format("Progress[bytesTransferred=%d, totalBytesTransferred=%d, timePassed=%s, totalTimePassed=%s, contentLength=%s]%s", this.bytesTransferred, this.totalBytesTransferred, this.timePassed, this.totalTimePassed, this.determinate() ? Long.valueOf(this.contentLength) : "UNKNOWN", this.determinate() ? " " + (double)Math.round(10000.0 * this.value()) / 100.0 + "%" : "");
        }
    }

    private static final class Options {
        final long bytesTransferredThreshold;
        final @Nullable Duration timePassedThreshold;
        final Executor executor;
        final boolean enclosedProgress;
        final Clock clock;

        Options(long bytesTransferredThreshold, @Nullable Duration timePassedThreshold, Executor executor, boolean enclosedProgress, Clock clock) {
            this.bytesTransferredThreshold = bytesTransferredThreshold;
            this.timePassedThreshold = timePassedThreshold;
            this.executor = Objects.requireNonNull(executor);
            this.enclosedProgress = enclosedProgress;
            this.clock = Objects.requireNonNull(clock);
        }
    }

    public static final class Builder {
        private long bytesTransferredThreshold;
        private @MonotonicNonNull Duration timePassedThreshold;
        private @MonotonicNonNull Executor executor;
        private boolean enclosedProgress = true;
        private Clock clock = Clock.systemUTC();

        Builder() {
        }

        @CanIgnoreReturnValue
        Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder bytesTransferredThreshold(long value) {
            Validate.requireArgument(value >= 0L, "negative threshold: %s", value);
            this.bytesTransferredThreshold = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder timePassedThreshold(Duration duration) {
            Objects.requireNonNull(duration);
            Utils.requireNonNegativeDuration(duration);
            this.timePassedThreshold = duration;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder enclosedProgress(boolean enclosedProgress) {
            this.enclosedProgress = enclosedProgress;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        public ProgressTracker build() {
            return new ProgressTracker(this);
        }
    }

    public static interface MultipartProgress
    extends Progress {
        public MultipartBodyPublisher.Part part();

        public Progress partProgress();

        public boolean partChanged();
    }

    public static interface Progress {
        public long bytesTransferred();

        public long totalBytesTransferred();

        public Duration timePassed();

        public Duration totalTimePassed();

        public long contentLength();

        public boolean done();

        default public double value() {
            long length = this.contentLength();
            if (length <= 0L) {
                return length == 0L ? 1.0 : Double.NaN;
            }
            return 1.0 * (double)this.totalBytesTransferred() / (double)length;
        }

        default public boolean determinate() {
            return this.contentLength() >= 0L;
        }

        public String toString();
    }

    @FunctionalInterface
    public static interface MultipartListener
    extends BaseListener<MultipartProgress> {
    }

    @FunctionalInterface
    public static interface Listener
    extends BaseListener<Progress> {
    }

    @FunctionalInterface
    private static interface BaseListener<P extends Progress>
    extends Flow.Subscriber<P> {
        @Override
        default public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        default public void onError(Throwable throwable) {
        }

        @Override
        default public void onComplete() {
        }
    }
}

