/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MimeBodyPublisher;
import com.github.mizosoft.methanol.MoreBodyPublishers;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.flow.AbstractPollableSubscription;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import com.github.mizosoft.methanol.internal.flow.Prefetcher;
import com.github.mizosoft.methanol.internal.flow.Upstream;
import com.github.mizosoft.methanol.internal.text.HttpCharMatchers;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MultipartBodyPublisher
implements MimeBodyPublisher {
    private static final System.Logger logger = System.getLogger(MultipartBodyPublisher.class.getName());
    private static final long UNKNOWN_LENGTH = -1L;
    private static final long UNINITIALIZED_LENGTH = -2L;
    private static final String BOUNDARY_ATTRIBUTE = "boundary";
    private final List<Part> parts;
    private final MediaType mediaType;
    private final String boundary;
    private long lazyContentLength = -2L;

    private MultipartBodyPublisher(List<Part> parts, MediaType mediaType) {
        this.parts = Objects.requireNonNull(parts);
        this.mediaType = Objects.requireNonNull(mediaType);
        String boundary = mediaType.parameters().get(BOUNDARY_ATTRIBUTE);
        Validate.requireArgument(boundary != null, "Missing boundary");
        this.boundary = Validate.castNonNull(boundary);
    }

    public String boundary() {
        return this.boundary;
    }

    public List<Part> parts() {
        return this.parts;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public long contentLength() {
        long contentLength = this.lazyContentLength;
        if (contentLength == -2L) {
            this.lazyContentLength = contentLength = this.computeContentLength();
        }
        return contentLength;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        new MultipartSubscription(this.boundary, this.parts, subscriber).fireOrKeepAlive();
    }

    private long computeContentLength() {
        long rawContentLength = 0L;
        StringBuilder metadata = new StringBuilder();
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = this.parts.get(i);
            long partContentLength = part.bodyPublisher().contentLength();
            if (partContentLength < 0L) {
                return -1L;
            }
            rawContentLength += partContentLength;
            BoundaryAppender.get(i, this.parts.size()).append(metadata, this.boundary);
            MultipartBodyPublisher.appendPartHeaders(metadata, part);
            metadata.append("\r\n");
        }
        BoundaryAppender.LAST.append(metadata, this.boundary);
        return rawContentLength + (long)StandardCharsets.UTF_8.encode(CharBuffer.wrap(metadata)).remaining();
    }

    private static void appendPartHeaders(StringBuilder target, Part part) {
        part.headers().map().forEach((name, values) -> values.forEach(value -> MultipartBodyPublisher.appendHeader(target, name, value)));
        HttpRequest.BodyPublisher publisher = part.bodyPublisher();
        if (publisher instanceof MimeBodyPublisher) {
            MultipartBodyPublisher.appendHeader(target, "Content-Type", ((MimeBodyPublisher)publisher).mediaType().toString());
        }
    }

    private static void appendHeader(StringBuilder target, String name, String value) {
        target.append(name).append(": ").append(value).append("\r\n");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static final class PartSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        static final ByteBuffer END_OF_PART = ByteBuffer.allocate(0);
        private final MultipartSubscription downstream;
        private final Upstream upstream = new Upstream();
        private final Prefetcher prefetcher = new Prefetcher();
        private final ConcurrentLinkedQueue<ByteBuffer> buffers = new ConcurrentLinkedQueue();

        PartSubscriber(MultipartSubscription downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription);
            if (this.upstream.setOrCancel(subscription)) {
                this.prefetcher.initialize(this.upstream);
            }
        }

        @Override
        public void onNext(ByteBuffer item) {
            this.buffers.add(item);
            this.downstream.fireOrKeepAliveOnNext();
        }

        @Override
        public void onError(Throwable throwable) {
            Objects.requireNonNull(throwable);
            this.abort(false);
            this.downstream.fireOrKeepAliveOnError(throwable);
        }

        @Override
        public void onComplete() {
            this.abort(false);
            this.buffers.add(END_OF_PART);
            this.downstream.fireOrKeepAlive();
        }

        void abort(boolean flowInterrupted) {
            this.upstream.cancel(flowInterrupted);
        }

        @Nullable ByteBuffer poll() {
            ByteBuffer next = this.buffers.poll();
            if (next != null && next != END_OF_PART) {
                this.prefetcher.update(this.upstream);
            }
            return next;
        }
    }

    private static final class MultipartSubscription
    extends AbstractPollableSubscription<ByteBuffer> {
        private static final VarHandle PART_SUBSCRIBER;
        private static final Flow.Subscriber<ByteBuffer> CANCELLED;
        private final String boundary;
        private final List<Part> parts;
        private int partIndex;
        private boolean complete;
        private volatile  @MonotonicNonNull Flow.Subscriber<ByteBuffer> partSubscriber;
        private final List<PartSequenceListener> listeners = new CopyOnWriteArrayList<PartSequenceListener>();

        MultipartSubscription(String boundary, List<Part> parts, Flow.Subscriber<? super ByteBuffer> downstream) {
            super(downstream, FlowSupport.SYNC_EXECUTOR);
            this.boundary = boundary;
            this.parts = parts;
        }

        void registerListener(PartSequenceListener listener) {
            this.listeners.add(listener.guarded());
        }

        @Override
        protected @Nullable ByteBuffer poll() {
            ByteBuffer next;
            Flow.Subscriber<ByteBuffer> subscriber = this.partSubscriber;
            if (subscriber instanceof PartSubscriber && (next = ((PartSubscriber)subscriber).poll()) != PartSubscriber.END_OF_PART) {
                return next;
            }
            return this.advancePart();
        }

        @Override
        protected boolean isComplete() {
            return this.complete;
        }

        @Override
        protected void abort(boolean flowInterrupted) {
            Flow.Subscriber subscriber = PART_SUBSCRIBER.getAndSet(this, CANCELLED);
            if (subscriber instanceof PartSubscriber) {
                ((PartSubscriber)subscriber).abort(flowInterrupted);
            }
        }

        private @Nullable ByteBuffer advancePart() {
            StringBuilder metadata = new StringBuilder();
            if (this.partIndex < this.parts.size()) {
                Part part = this.parts.get(this.partIndex);
                if (!this.subscribeTo(part.bodyPublisher())) {
                    return null;
                }
                BoundaryAppender.get(this.partIndex, this.parts.size()).append(metadata, this.boundary);
                MultipartBodyPublisher.appendPartHeaders(metadata, part);
                metadata.append("\r\n");
                ++this.partIndex;
                this.listeners.forEach(listener -> listener.onNextPart(part));
            } else if (this.partIndex == this.parts.size()) {
                BoundaryAppender.LAST.append(metadata, this.boundary);
                ++this.partIndex;
                this.complete = true;
                this.partSubscriber = CANCELLED;
                this.listeners.forEach(PartSequenceListener::onSequenceCompletion);
            } else {
                return null;
            }
            return StandardCharsets.UTF_8.encode(CharBuffer.wrap(metadata));
        }

        private boolean subscribeTo(HttpRequest.BodyPublisher bodyPublisher) {
            PartSubscriber nextSubscriber;
            Flow.Subscriber<ByteBuffer> currentSubscriber = this.partSubscriber;
            if (currentSubscriber != CANCELLED && PART_SUBSCRIBER.compareAndSet(this, currentSubscriber, nextSubscriber = new PartSubscriber(this))) {
                bodyPublisher.subscribe(nextSubscriber);
                return true;
            }
            return false;
        }

        static {
            try {
                PART_SUBSCRIBER = MethodHandles.lookup().findVarHandle(MultipartSubscription.class, "partSubscriber", Flow.Subscriber.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
            CANCELLED = new Flow.Subscriber<ByteBuffer>(){

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                }

                @Override
                public void onNext(ByteBuffer item) {
                }

                @Override
                public void onError(Throwable throwable) {
                }

                @Override
                public void onComplete() {
                }
            };
        }
    }

    private static enum BoundaryAppender {
        FIRST("--", "\r\n"),
        MIDDLE("\r\n--", "\r\n"),
        LAST("\r\n--", "--\r\n");

        private final String prefix;
        private final String suffix;

        private BoundaryAppender(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        void append(StringBuilder target, String boundary) {
            target.append(this.prefix).append(boundary).append(this.suffix);
        }

        static BoundaryAppender get(int partIndex, int partsSize) {
            return partIndex == 0 ? FIRST : (partIndex < partsSize ? MIDDLE : LAST);
        }
    }

    static interface PartSequenceListener {
        public void onNextPart(Part var1);

        public void onSequenceCompletion();

        default public PartSequenceListener guarded() {
            return new PartSequenceListener(){

                @Override
                public void onNextPart(Part part) {
                    try {
                        this.onNextPart(part);
                    }
                    catch (Throwable e) {
                        logger.log(System.Logger.Level.WARNING, "exception thrown by PartSequenceListener::onNextPart", e);
                    }
                }

                @Override
                public void onSequenceCompletion() {
                    try {
                        this.onSequenceCompletion();
                    }
                    catch (Throwable e) {
                        logger.log(System.Logger.Level.WARNING, "exception thrown by PartSequenceListener::onSequenceCompletion", e);
                    }
                }
            };
        }

        public static void register(Flow.Subscription subscription, PartSequenceListener listener) {
            Validate.requireArgument(subscription instanceof MultipartSubscription, "not a multipart subscription");
            ((MultipartSubscription)subscription).registerListener(listener);
        }
    }

    public static final class Builder {
        private static final int MAX_BOUNDARY_LENGTH = 70;
        private static final MediaType DEFAULT_MULTIPART_MEDIA_TYPE = MediaType.of("multipart", "form-data");
        private final List<Part> parts = new ArrayList<Part>();
        private MediaType mediaType = DEFAULT_MULTIPART_MEDIA_TYPE;

        @CanIgnoreReturnValue
        public Builder boundary(String boundary) {
            this.mediaType = this.mediaType.withParameter(MultipartBodyPublisher.BOUNDARY_ATTRIBUTE, Builder.requireValidBoundary(boundary));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder mediaType(MediaType mediaType) {
            this.mediaType = Builder.requireValidMediaType(mediaType);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder part(Part part) {
            this.parts.add(Objects.requireNonNull(part));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder formPart(String name, HttpRequest.BodyPublisher bodyPublisher) {
            return this.part(Part.create(Builder.getFormHeaders(name, null), bodyPublisher));
        }

        @CanIgnoreReturnValue
        public Builder formPart(String name, String filename, HttpRequest.BodyPublisher bodyPublisher) {
            return this.part(Part.create(Builder.getFormHeaders(name, filename), bodyPublisher));
        }

        @CanIgnoreReturnValue
        public Builder formPart(String name, String filename, HttpRequest.BodyPublisher bodyPublisher, MediaType mediaType) {
            return this.formPart(name, filename, MoreBodyPublishers.ofMediaType(bodyPublisher, mediaType));
        }

        @CanIgnoreReturnValue
        public Builder textPart(String name, Object value) {
            return this.textPart(name, value, StandardCharsets.UTF_8);
        }

        @CanIgnoreReturnValue
        public Builder textPart(String name, Object value, Charset charset) {
            return this.formPart(name, HttpRequest.BodyPublishers.ofString(value.toString(), charset));
        }

        @CanIgnoreReturnValue
        public Builder filePart(String name, Path file) throws FileNotFoundException {
            return this.filePart(name, file, Builder.probeMediaType(file));
        }

        @CanIgnoreReturnValue
        public Builder filePart(String name, Path file, MediaType mediaType) throws FileNotFoundException {
            Path filenameComponent = file.getFileName();
            String filenameString = filenameComponent != null ? filenameComponent.toString() : "";
            MimeBodyPublisher publisher = MoreBodyPublishers.ofMediaType(HttpRequest.BodyPublishers.ofFile(file), mediaType);
            return this.formPart(name, filenameString, publisher);
        }

        public MultipartBodyPublisher build() {
            List<Part> partsCopy = List.copyOf(this.parts);
            Validate.requireState(!partsCopy.isEmpty(), "at least one part must be added");
            MediaType localMediaType = this.mediaType;
            if (!localMediaType.parameters().containsKey(MultipartBodyPublisher.BOUNDARY_ATTRIBUTE)) {
                localMediaType = localMediaType.withParameter(MultipartBodyPublisher.BOUNDARY_ATTRIBUTE, UUID.randomUUID().toString());
            }
            return new MultipartBodyPublisher(partsCopy, localMediaType);
        }

        @CanIgnoreReturnValue
        private static String requireValidBoundary(String boundary) {
            Validate.requireArgument(boundary.length() <= 70 && !boundary.isEmpty(), "illegal boundary length: %s", boundary.length());
            Validate.requireArgument(HttpCharMatchers.BOUNDARY_MATCHER.allMatch(boundary) && !boundary.endsWith(" "), "illegal boundary: '%s'", boundary);
            return boundary;
        }

        @CanIgnoreReturnValue
        private static MediaType requireValidMediaType(MediaType mediaType) {
            Validate.requireArgument(mediaType.type().equals("multipart"), "Not a multipart type: %s", mediaType.type());
            String boundary = mediaType.parameters().get(MultipartBodyPublisher.BOUNDARY_ATTRIBUTE);
            if (boundary != null) {
                Builder.requireValidBoundary(boundary);
            }
            return mediaType;
        }

        private static HttpHeaders getFormHeaders(String name, @Nullable String filename) {
            StringBuilder contentDisposition = new StringBuilder();
            Builder.appendEscaped(contentDisposition.append("form-data; name="), name);
            if (filename != null) {
                Builder.appendEscaped(contentDisposition.append("; filename="), filename);
            }
            return HttpHeaders.of(Map.of("Content-Disposition", List.of(contentDisposition.toString())), (__, ___) -> true);
        }

        private static void appendEscaped(StringBuilder target, String field) {
            target.append("\"");
            for (int i = 0; i < field.length(); ++i) {
                char c = field.charAt(i);
                if (c == '\\' || c == '\"') {
                    target.append('\\');
                }
                target.append(c);
            }
            target.append("\"");
        }

        private static MediaType probeMediaType(Path file) {
            try {
                String contentType = Files.probeContentType(file);
                if (contentType != null) {
                    return MediaType.parse(contentType);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }

    public static final class Part {
        private final HttpHeaders headers;
        private final HttpRequest.BodyPublisher bodyPublisher;

        Part(HttpHeaders headers, HttpRequest.BodyPublisher bodyPublisher) {
            this.headers = Objects.requireNonNull(headers);
            this.bodyPublisher = Objects.requireNonNull(bodyPublisher);
            Part.validateHeaderNames(headers.map().keySet(), bodyPublisher);
        }

        public HttpHeaders headers() {
            return this.headers;
        }

        public HttpRequest.BodyPublisher bodyPublisher() {
            return this.bodyPublisher;
        }

        public static Part create(HttpHeaders headers, HttpRequest.BodyPublisher bodyPublisher) {
            return new Part(headers, bodyPublisher);
        }

        private static void validateHeaderNames(Set<String> names, HttpRequest.BodyPublisher publisher) {
            Validate.requireArgument(!names.contains("Content-Type") || !(publisher instanceof MimeBodyPublisher), "unexpected Content-Type header");
            names.forEach(Utils::requireValidHeaderName);
        }
    }
}

