/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.AdapterCodec;
import com.github.mizosoft.methanol.BodyAdapter;
import com.github.mizosoft.methanol.BodyDecoder;
import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MoreBodySubscribers;
import com.github.mizosoft.methanol.TypeRef;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.concurrent.Delayer;
import com.github.mizosoft.methanol.internal.extensions.ImmutableResponseInfo;
import java.io.Reader;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MoreBodyHandlers {
    private MoreBodyHandlers() {
    }

    public static <T, S extends Flow.Subscriber<? super List<ByteBuffer>>> HttpResponse.BodyHandler<T> fromAsyncSubscriber(S downstream, Function<? super S, ? extends CompletionStage<T>> asyncFinisher) {
        Objects.requireNonNull(downstream);
        Objects.requireNonNull(asyncFinisher);
        return responseInfo -> MoreBodySubscribers.fromAsyncSubscriber(downstream, asyncFinisher);
    }

    public static <T> HttpResponse.BodyHandler<T> withReadTimeout(HttpResponse.BodyHandler<T> delegate, Duration timeout) {
        return MoreBodyHandlers.withReadTimeout(delegate, timeout, Delayer.defaultDelayer());
    }

    public static <T> HttpResponse.BodyHandler<T> withReadTimeout(HttpResponse.BodyHandler<T> delegate, Duration timeout, ScheduledExecutorService scheduler) {
        return MoreBodyHandlers.withReadTimeout(delegate, timeout, Delayer.of(scheduler));
    }

    static <T> HttpResponse.BodyHandler<T> withReadTimeout(HttpResponse.BodyHandler<T> delegate, Duration timeout, Delayer delayer) {
        Objects.requireNonNull(delegate);
        Utils.requirePositiveDuration(timeout);
        Objects.requireNonNull(delayer);
        return responseInfo -> MoreBodySubscribers.withReadTimeout(delegate.apply(responseInfo), timeout, delayer);
    }

    public static HttpResponse.BodyHandler<ReadableByteChannel> ofByteChannel() {
        return responseInfo -> MoreBodySubscribers.ofByteChannel();
    }

    public static HttpResponse.BodyHandler<Reader> ofReader() {
        return responseInfo -> MoreBodySubscribers.ofReader(MoreBodyHandlers.charsetOrUtf8(responseInfo.headers()));
    }

    public static HttpResponse.BodyHandler<Reader> ofReader(Charset charset) {
        Objects.requireNonNull(charset);
        return responseInfo -> MoreBodySubscribers.ofReader(charset);
    }

    public static <T> HttpResponse.BodyHandler<T> ofObject(Class<T> type) {
        return MoreBodyHandlers.ofObject(TypeRef.of(type));
    }

    public static <T> HttpResponse.BodyHandler<T> ofObject(TypeRef<T> typeRef) {
        return AdapterCodec.installed().handlerOf(typeRef, BodyAdapter.Hints.empty());
    }

    public static <T> HttpResponse.BodyHandler<Supplier<T>> ofDeferredObject(Class<T> type) {
        return MoreBodyHandlers.ofDeferredObject(TypeRef.of(type));
    }

    public static <T> HttpResponse.BodyHandler<Supplier<T>> ofDeferredObject(TypeRef<T> typeRef) {
        return AdapterCodec.installed().deferredHandlerOf(typeRef, BodyAdapter.Hints.empty());
    }

    public static <T> HttpResponse.BodyHandler<T> decoding(HttpResponse.BodyHandler<T> downstreamBodyHandler) {
        return new DecodingHandler<T>(downstreamBodyHandler, null);
    }

    public static <T> HttpResponse.BodyHandler<T> decoding(HttpResponse.BodyHandler<T> downstreamHandler, @Nullable Executor executor) {
        return new DecodingHandler<T>(downstreamHandler, executor);
    }

    private static Charset charsetOrUtf8(HttpHeaders headers) {
        return headers.firstValue("Content-Type").map(contentType -> MediaType.parse(contentType).charsetOrDefault(StandardCharsets.UTF_8)).orElse(StandardCharsets.UTF_8);
    }

    private static final class DecodingHandler<T>
    implements HttpResponse.BodyHandler<T> {
        private final HttpResponse.BodyHandler<T> downstreamBodyHandler;
        private final @Nullable Executor executor;

        DecodingHandler(HttpResponse.BodyHandler<T> downstreamBodyHandler, @Nullable Executor executor) {
            this.downstreamBodyHandler = Objects.requireNonNull(downstreamBodyHandler);
            this.executor = executor;
        }

        @Override
        public HttpResponse.BodySubscriber<T> apply(HttpResponse.ResponseInfo responseInfo) {
            return responseInfo.headers().firstValue("Content-Encoding").map(encoding -> this.wrapDownstream((String)encoding, responseInfo)).orElseGet(() -> this.downstreamBodyHandler.apply(responseInfo));
        }

        private HttpResponse.BodySubscriber<T> wrapDownstream(String encoding, HttpResponse.ResponseInfo responseInfo) {
            BodyDecoder.Factory factory = BodyDecoder.Factory.getFactory(encoding).orElseThrow(() -> new UnsupportedOperationException("unsupported encoding"));
            HttpHeaders strippedHeaders = HttpHeaders.of(responseInfo.headers().map(), (name, value) -> !"Content-Encoding".equalsIgnoreCase((String)name) && !"Content-Length".equalsIgnoreCase((String)name));
            HttpResponse.BodySubscriber<T> downstreamSubscriber = this.downstreamBodyHandler.apply(new ImmutableResponseInfo(responseInfo.statusCode(), strippedHeaders, responseInfo.version()));
            return this.executor != null ? factory.create(downstreamSubscriber, this.executor) : factory.create(downstreamSubscriber);
        }
    }
}

