/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.text.HeaderValueTokenizer;
import com.github.mizosoft.methanol.internal.text.HttpCharMatchers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MediaType {
    private static final String CHARSET_ATTRIBUTE = "charset";
    private static final String WILDCARD = "*";
    private static final String APPLICATION_TYPE = "application";
    private static final String IMAGE_TYPE = "image";
    private static final String TEXT_TYPE = "text";
    public static final MediaType ANY = new MediaType("*", "*");
    public static final MediaType APPLICATION_ANY = new MediaType("application", "*");
    public static final MediaType IMAGE_ANY = new MediaType("image", "*");
    public static final MediaType TEXT_ANY = new MediaType("text", "*");
    public static final MediaType APPLICATION_FORM_URLENCODED = new MediaType("application", "x-www-form-urlencoded");
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    public static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    public static final MediaType APPLICATION_XHTML_XML = new MediaType("application", "xhtml+xml");
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    public static final MediaType APPLICATION_X_PROTOBUF = new MediaType("application", "x-protobuf");
    public static final MediaType IMAGE_GIF = new MediaType("image", "gif");
    public static final MediaType IMAGE_JPEG = new MediaType("image", "jpeg");
    public static final MediaType IMAGE_PNG = new MediaType("image", "png");
    public static final MediaType TEXT_HTML = new MediaType("text", "html");
    public static final MediaType TEXT_MARKDOWN = new MediaType("text", "markdown");
    public static final MediaType TEXT_PLAIN = new MediaType("text", "plain");
    public static final MediaType TEXT_XML = new MediaType("text", "xml");
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private @MonotonicNonNull Charset lazyCharset;
    private boolean isCharsetParsed;
    private @MonotonicNonNull String lazyToString;

    private MediaType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = Map.of();
    }

    private MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Optional<Charset> charset() {
        if (!this.isCharsetParsed) {
            String charsetName = this.parameters.get(CHARSET_ATTRIBUTE);
            if (charsetName != null) {
                this.lazyCharset = Charset.forName(charsetName);
            }
            this.isCharsetParsed = true;
        }
        return Optional.ofNullable(this.lazyCharset);
    }

    public Charset charsetOrDefault(Charset defaultCharset) {
        Objects.requireNonNull(defaultCharset);
        try {
            return this.charset().orElse(defaultCharset);
        }
        catch (UnsupportedCharsetException ignored) {
            return defaultCharset;
        }
    }

    public Charset charsetOrUtf8() {
        return this.charsetOrDefault(StandardCharsets.UTF_8);
    }

    public boolean hasWildcard() {
        return this.type.equals(WILDCARD) || this.subtype.equals(WILDCARD);
    }

    public boolean includes(MediaType other) {
        return this.includes(other.type, other.subtype) && other.parameters.entrySet().containsAll(this.parameters.entrySet());
    }

    private boolean includes(String otherType, String otherSubtype) {
        return this.type.equals(WILDCARD) || this.type.equals(otherType) && this.includesSubtype(otherSubtype);
    }

    private boolean includesSubtype(String otherSubtype) {
        int structuredSuffixIndex;
        return this.subtype.equals(WILDCARD) || this.subtype.equals(otherSubtype) || (structuredSuffixIndex = otherSubtype.lastIndexOf(43)) != -1 && otherSubtype.regionMatches(structuredSuffixIndex + 1, this.subtype, 0, this.subtype.length());
    }

    public boolean isCompatibleWith(MediaType other) {
        return this.includes(other) || other.includes(this);
    }

    public MediaType withCharset(Charset charset) {
        Objects.requireNonNull(charset);
        MediaType mediaType = this.withParameter(CHARSET_ATTRIBUTE, charset.name());
        mediaType.lazyCharset = charset;
        mediaType.isCharsetParsed = true;
        return mediaType;
    }

    public MediaType withParameter(String name, String value) {
        return this.withParameters(Map.of(name, value));
    }

    public MediaType withParameters(Map<String, String> parameters) {
        return MediaType.of(this.type, this.subtype, parameters, new LinkedHashMap<String, String>(this.parameters));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equals(other.type) && this.subtype.equals(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype, this.parameters);
    }

    public String toString() {
        String toString = this.lazyToString;
        if (toString == null) {
            this.lazyToString = toString = this.computeToString();
        }
        return toString;
    }

    private String computeToString() {
        StringBuilder sb = new StringBuilder().append(this.type).append("/").append(this.subtype);
        this.parameters.forEach((name, value) -> sb.append("; ").append((String)name).append("=").append(Utils.escapeAndQuoteValueIfNeeded(value)));
        return sb.toString();
    }

    public static MediaType of(String type, String subtype) {
        return MediaType.of(type, subtype, Map.of());
    }

    public static MediaType of(String type, String subtype, Map<String, String> parameters) {
        return MediaType.of(type, subtype, parameters, new LinkedHashMap<String, String>());
    }

    private static MediaType of(String type, String subtype, Map<String, String> untrustedParameters, Map<String, String> trustedParameters) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(subtype);
        Objects.requireNonNull(untrustedParameters);
        Objects.requireNonNull(trustedParameters);
        Validate.requireArgument(!type.equals(WILDCARD) || subtype.equals(WILDCARD), "Cannot have a wildcard type with a concrete subtype");
        String normalizedType = MediaType.validateAndNormalizeToken(type);
        String normalizedSubtype = MediaType.validateAndNormalizeToken(subtype);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(trustedParameters);
        for (Map.Entry<String, String> entry : untrustedParameters.entrySet()) {
            String normalizedValue;
            String normalizedAttribute = MediaType.validateAndNormalizeToken(entry.getKey());
            if (normalizedAttribute.equals(CHARSET_ATTRIBUTE)) {
                normalizedValue = MediaType.validateAndNormalizeToken(entry.getValue());
            } else {
                normalizedValue = entry.getValue();
                Validate.requireArgument(HttpCharMatchers.QUOTED_PAIR_MATCHER.allMatch(normalizedValue), "Illegal value: '%s'", normalizedValue);
            }
            parameters.put(normalizedAttribute, normalizedValue);
        }
        return new MediaType(normalizedType, normalizedSubtype, Collections.unmodifiableMap(parameters));
    }

    private static String validateAndNormalizeToken(String token) {
        return Utils.requireValidToken(token).toLowerCase(Locale.ROOT);
    }

    public static MediaType parse(String value) {
        try {
            HeaderValueTokenizer tokenizer = new HeaderValueTokenizer(value);
            String type = tokenizer.nextToken();
            tokenizer.requireCharacter('/');
            String subtype = tokenizer.nextToken();
            LinkedHashMap<String, String> parameters = null;
            while (tokenizer.consumeDelimiter(';')) {
                if (parameters == null) {
                    parameters = new LinkedHashMap<String, String>();
                }
                String name = tokenizer.nextToken();
                tokenizer.requireCharacter('=');
                parameters.put(name, tokenizer.nextTokenOrQuotedString());
            }
            return parameters != null ? MediaType.of(type, subtype, parameters) : MediaType.of(type, subtype);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IllegalArgumentException("Couldn't parse: '" + value + "'", e);
        }
    }
}

